/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.menu;

import java.util.Map;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.menu.MenuItem;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.jsoup.nodes.Element;

public class WebMenuItem
extends AbstractTemplateWebComponent {
    static final String COMPONENT_TYPE = "menuitem";
    private static final String LINK = "link";
    private static Element componentHtmlTemplate;
    private Element link;

    public WebMenuItem(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    protected MenuItem getMenuItem() {
        return (MenuItem)this.component;
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.link = this.htmlOuterElement.getElementsByTag("a").first();
        this.link.attr("href", "javascript:{}");
        String onclick = String.format("_plum_post('%s','%s','click')", this.getId(), LINK);
        this.link.attr("onclick", onclick);
        this.link.appendText(this.getComponent().getCaption());
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.CLICK) {
            return new AbstractViewAction(event.name()){

                public void execute(Component view) {
                    MenuItem item = (MenuItem)view;
                    item.click();
                }
            };
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return COMPONENT_TYPE;
    }
}

