/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.input.value.UrlFile;
import net.abstractfactory.plum.input.value.video.Video;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.VideoBox;
import net.abstractfactory.plum.view.component.audiobox.AudioBox;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import net.abstractfactory.plum.view.web.component.MultipartFileSender;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class WebVideoBox
extends AbstractTemplateWebComponent {
    private static Element componentHtmlTemplate;
    private final String INPUT_NAME = "video";
    private Element video;
    private Element source;

    public WebVideoBox(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private VideoBox getVideobox() {
        return (VideoBox)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), false);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.source = this.htmlInnerElement.getElementsByClass("video-source").first();
        this.source.remove();
        this.htmlInnerElement.empty();
        this.video = this.htmlOuterElement;
        VideoBox videoBox = this.getVideobox();
        if (videoBox.isShowControls()) {
            this.video.attr("controls", "controls");
        } else {
            this.video.removeAttr("controls");
        }
        if (videoBox.isAutoPlay()) {
            this.video.attr("autoplay", "autoplay");
        }
        if (videoBox.isMuted()) {
            this.video.attr("muted", "muted");
        }
        if (videoBox.isLoop()) {
            this.video.attr("loop", "loop");
        }
        this.source.attr("src", WebFileUtils.generateUrl(this.getId(), "video", videoBox.getDataVersionAsString()));
        this.source.attr("type", ((Video)videoBox.getData()).getFile().getContentType());
        this.htmlInnerElement.appendChild((Node)this.source);
        this.htmlInnerElement.appendText("Your browser not support video element");
    }

    @Override
    public void writeFile(HttpServletRequest req, HttpServletResponse response, String shortName) throws IOException {
        Video video = (Video)this.getVideobox().getData();
        if (video != null) {
            File fileValue = video.getFile();
            if (fileValue instanceof UrlFile) {
                UrlFile urlFile = (UrlFile)fileValue;
                if (urlFile.getUrl().getProtocol().equalsIgnoreCase("file")) {
                    try {
                        String filePath = urlFile.getUrl().toURI().toString();
                        System.out.println("file path:" + filePath);
                        MultipartFileSender.fromURIString(filePath).with(req).with(response).serveResource();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.writeFile(response, video.getFile());
                }
            } else {
                this.writeFile(response, video.getFile());
            }
        }
    }

    protected ViewAction onValueChange(String newValue) {
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                AudioBox box = (AudioBox)view;
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            String newValue = (String)parameters.get("video");
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "videobox";
    }
}

