/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.TextBox;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class WebTextBox
extends AbstractWebComponent {
    public static final String VALUE_CHANGE = "valueChange";
    private final String INPUT_NAME = "text";
    public static final String PARAMETER_KEY_CODE = "keyCode";
    private Element text;

    public WebTextBox(String id, Component component) {
        super(id, component);
    }

    protected TextBox getTextBox() {
        return (TextBox)this.component;
    }

    @Override
    public void createHtmlElement() {
        TextBox textBox = this.getTextBox();
        this.text = new Element(Tag.valueOf((String)"input"), "");
        if (textBox.isMasked()) {
            this.text.attr("type", "password");
        } else {
            this.text.attr("type", "text");
        }
        if (textBox.getText() != null) {
            this.text.attr("value", textBox.getText());
        }
        this.text.attr("name", this.getFullInputName("text"));
        this.htmlInnerElement = this.htmlOuterElement = this.text;
        if (textBox.containsListener("keyPress")) {
            String onKeyPress;
            if (textBox.getPressKeys() == null) {
                onKeyPress = String.format("return submitWhenKeyPress(event, '%s','%s','%s','%s'); ", this.getId(), "input", WebEvent.KEY_PRESS.name(), PARAMETER_KEY_CODE);
            } else {
                StringBuilder sb = new StringBuilder();
                int count = 0;
                for (Integer num : textBox.getPressKeys()) {
                    if (count > 0) {
                        sb.append(",");
                    }
                    sb.append(num);
                    ++count;
                }
                String keysStr = sb.toString();
                onKeyPress = String.format("return submitWhenKeyPress(event, '%s','%s','%s','%s',[%s]); ", this.getId(), "input", WebEvent.KEY_PRESS.name(), PARAMETER_KEY_CODE, keysStr);
            }
            this.text.attr("onKeyUp", onKeyPress);
        } else {
            this.text.attr("onKeyUp", "return preventSubmitForm(event);");
        }
    }

    protected ViewAction onValueChange(String newValue) {
        this.text.attr("value", newValue);
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                TextBox tb = (TextBox)view;
                tb.setText(WebTextBox.this.text.attr("value"), true);
            }
        };
    }

    protected ViewAction onKeyPress(final long keyCode) {
        return new AbstractViewAction(WebEvent.KEY_PRESS.name()){

            public void execute(Component view) {
                TextBox tb = (TextBox)view;
                tb.notifyEventListeners("keyPress", new Object[]{keyCode});
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            String newValue = (String)parameters.get("text");
            return this.onValueChange(newValue);
        }
        if (event == WebEvent.KEY_PRESS) {
            String keyCodeStr = (String)parameters.get(PARAMETER_KEY_CODE);
            long keyCode = Long.valueOf(keyCodeStr);
            return this.onKeyPress(keyCode);
        }
        throw new RuntimeException("unknow event:" + event);
    }
}

