/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.TextArea;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class WebTextArea
extends AbstractWebComponent {
    public static final String VALUE_CHANGE = "valueChange";
    private final String INPUT_NAME = "text";
    private Element textarea;

    public WebTextArea(String id, Component component) {
        super(id, component);
    }

    protected TextArea getTextArea() {
        return (TextArea)this.component;
    }

    @Override
    public void createHtmlElement() {
        this.textarea = new Element(Tag.valueOf((String)"textarea"), "");
        if (this.getTextArea().getText() != null) {
            this.textarea.appendText(this.getTextArea().getText());
        }
        this.textarea.attr("name", this.getFullInputName("text"));
        this.htmlInnerElement = this.htmlOuterElement = this.textarea;
    }

    protected ViewAction onValueChange(String newValue) {
        this.textarea.text(newValue);
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                TextArea tb = (TextArea)view;
                tb.setText(WebTextArea.this.textarea.text(), true);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            String newValue = (String)parameters.get("text");
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }
}

