/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.SpinBox;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.jsoup.nodes.Element;

public class WebSpinBox
extends AbstractTemplateWebComponent {
    private static Element componentHtmlTemplate;
    private final String INPUT_NAME = "text";
    private Element text;

    public WebSpinBox(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private SpinBox getSpinbox() {
        return (SpinBox)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.text = this.htmlInnerElement = componentElements.getInner();
        this.text.attr("name", this.getFullInputName("text"));
        this.text.attr("minimum", String.valueOf(this.getSpinbox().getMin().toString()));
        this.text.attr("maximum", String.valueOf(this.getSpinbox().getMax()));
        this.text.attr("step", String.valueOf(this.getSpinbox().getStep()));
        this.text.attr("value", String.valueOf(this.getSpinbox().getValue()));
    }

    protected ViewAction onValueChange(String newValue) {
        this.text.attr("value", newValue);
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                SpinBox tb = (SpinBox)view;
                tb.setValue(Integer.valueOf(WebSpinBox.this.text.attr("value")), true);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            String newValue = (String)parameters.get("text");
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "spinbox";
    }
}

