/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;
import net.abstractfactory.common.TreeNode;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.RadioBox;
import net.abstractfactory.plum.view.component.RadioItem;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.jsoup.nodes.Element;

public class WebRadioItem
extends AbstractTemplateWebComponent {
    public static final String VALUE_CHANGE = "valueChange";
    private static final String INPUT = "input";
    private static Element componentHtmlTemplate;
    private Element inputElement;

    public WebRadioItem(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private RadioItem getRadioItem() {
        return (RadioItem)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        RadioItem radioItem = this.getRadioItem();
        RadioBox radioBox = radioItem.getRadioBox();
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), false);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.inputElement = this.findElementByClass(INPUT);
        this.inputElement.attr("name", this.getFullInputName(radioBox.getId(), INPUT));
        int index = radioBox.indexOf((TreeNode)radioItem);
        this.inputElement.attr("value", String.valueOf(index));
        this.htmlInnerElement.empty();
    }

    protected ViewAction onValueChange(Object newValue) {
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                RadioItem radioItem = (RadioItem)view;
                RadioBox radioBox = radioItem.getRadioBox();
                radioBox.setSelectedItem(radioItem);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            Object newValue = parameters.get(INPUT);
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "radioitem";
    }
}

