/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.abstractfactory.plum.input.value.image.Image;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.RadioBox;
import net.abstractfactory.plum.view.component.ViewOption;
import net.abstractfactory.plum.view.component.listbox.Options;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.jsoup.nodes.Element;

public class WebRadioBox
extends AbstractTemplateWebComponent {
    public static final String VALUE_CHANGE = "valueChange";
    private static final String INPUT = "input";
    private static Element componentHtmlTemplate;
    private List<ViewOption> options;
    private int selectedIndex = -1;

    public WebRadioBox(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private RadioBox getRadioBox() {
        return (RadioBox)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        RadioBox radioBox = this.getRadioBox();
        this.createViewOptions(radioBox);
        this.selectedIndex = radioBox.getSelectedIndex();
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), false);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.htmlInnerElement.empty();
    }

    private void createViewOptions(RadioBox radioField) {
        this.options = new ArrayList<ViewOption>();
        Options inputOptions = radioField.getOptions();
        for (int i = 0; i < inputOptions.size(); ++i) {
            String str;
            Object obj = inputOptions.get(i);
            String value = str = obj == null ? "" : obj.toString();
            String text = str;
            Image image = null;
            ViewOption option = new ViewOption(value, text, image);
            this.options.add(option);
        }
    }

    protected ViewAction onValueChange(final Integer newValue) {
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                WebRadioBox.this.setSelectedIndex(newValue);
                RadioBox radioBox = (RadioBox)view;
                radioBox.setSelectedIndex(WebRadioBox.this.selectedIndex);
            }
        };
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            String newValueStr = (String)parameters.get(INPUT);
            Integer newValue = Integer.valueOf(newValueStr);
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "radiobox";
    }
}

