/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.abstractfactory.common.ListValueMap;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.ListBox;
import net.abstractfactory.plum.view.component.ViewOption;
import net.abstractfactory.plum.view.component.listbox.Options;
import net.abstractfactory.plum.view.component.listbox.SelectionMode;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;

public class WebListBox
extends AbstractWebComponent {
    public static final String VALUE_CHANGE = "valueChange";
    private final String INPUT_NAME = "select";
    private Element select;
    private List<ViewOption> optionList;
    private Set<Integer> selectedIndices = new HashSet<Integer>();

    public WebListBox(String id, Component component) {
        super(id, component);
    }

    protected ListBox getListBox() {
        return (ListBox)this.component;
    }

    @Override
    public void createHtmlElement() {
        ListBox listBox = this.getListBox();
        this.optionList = new ArrayList<ViewOption>();
        Options inputOptions = listBox.getOptions();
        for (int i = 0; i < inputOptions.size(); ++i) {
            String str;
            Object obj = inputOptions.get(i);
            String value = str = obj == null ? "" : obj.toString();
            String text = str;
            ViewOption option = new ViewOption(value, text);
            this.optionList.add(option);
        }
        this.selectedIndices.addAll(listBox.getSelectedIndices());
        this.select = new Element(Tag.valueOf((String)"select"), "");
        if (listBox.getSelectionMode() == SelectionMode.MULTIPLE) {
            this.select.attr("multiple", "");
        }
        this.select.attr("id", this.id);
        this.select.attr("name", this.getFullInputName("select"));
        this.select.attr("size", "4");
        this.createOptionElements(this.select);
        if (this.getListBox().containsListener(VALUE_CHANGE)) {
            String onChange = String.format("_plum_post('%s','%s','%s')", this.getId(), "select", WebEvent.VALUE_SET.name());
            this.select.attr("onChange", onChange);
        }
        this.htmlOuterElement = this.select;
        this.htmlInnerElement = null;
    }

    private boolean isSelected(int index) {
        for (int i : this.selectedIndices) {
            if (i != index) continue;
            return true;
        }
        return false;
    }

    private void createOptionElements(Element select) {
        for (int i = 0; i < this.optionList.size(); ++i) {
            ViewOption option = this.optionList.get(i);
            Element optionElement = new Element(Tag.valueOf((String)"option"), "");
            optionElement.attr("value", option.getValue());
            optionElement.appendText(option.getText());
            if (this.isSelected(i)) {
                optionElement.attr("selected", "selected");
            }
            select.appendChild((Node)optionElement);
        }
    }

    protected ViewAction onValueChange(List<Object> newValue) {
        this.selectedIndices.clear();
        for (int j = 0; j < newValue.size(); ++j) {
            String newVal = (String)newValue.get(j);
            for (int i = 0; i < this.optionList.size(); ++i) {
                ViewOption si = this.optionList.get(i);
                if (!si.getValue().equals(newVal)) continue;
                this.selectedIndices.add(i);
            }
        }
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                ListBox listBox = (ListBox)view;
                listBox.setSelectedIndices(WebListBox.this.selectedIndices, true);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, ListValueMap<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            List newValue = parameters.get((Object)"select");
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }
}

