/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.abstractfactory.plum.input.value.image.Image;
import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.ImageButton;
import net.abstractfactory.plum.view.component.attribute.Length;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.CSSAttribute;
import net.abstractfactory.plum.view.web.CSSAttributes;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.jsoup.nodes.Element;

public class WebImageButton
extends AbstractTemplateWebComponent {
    private static Element componentHtmlTemplate;
    private final String BUTTON = "button";
    private final String IMAGE = "image";
    Element buttonElement;
    Element imageElement;

    public WebImageButton(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private ImageButton getImageButton() {
        return (ImageButton)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), false);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.buttonElement = this.htmlOuterElement;
        this.imageElement = this.findElementByClass("image");
        this.applyEvents(this.buttonElement, "button", "click");
        this.imageElement.attr("id", this.id);
        this.imageElement.attr("src", WebFileUtils.generateUrl(this.getId(), "image"));
        this.applyStyle(this.imageElement, this.createImageStyles());
        this.buttonElement.attr("name", this.getFullInputName("button"));
    }

    @Override
    protected CSSAttributes createCommonStyles() {
        CSSAttributes attrs = super.createCommonStyles();
        attrs.remove("width");
        attrs.remove("height");
        return attrs;
    }

    private CSSAttributes createImageStyles() {
        Length height;
        Component comp = this.getComponent();
        CSSAttributes attrs = new CSSAttributes();
        Length width = comp.getWidth();
        if (width != null) {
            attrs.add(new CSSAttribute("width", width.getCssExpr()));
        }
        if ((height = comp.getHeight()) != null) {
            attrs.add(new CSSAttribute("height", height.getCssExpr()));
        }
        return attrs;
    }

    @Override
    public void writeFile(HttpServletRequest req, HttpServletResponse response, String shortName) throws IOException {
        Image image = this.getImageButton().getImage();
        if (image != null) {
            this.writeFile(response, image.getFile());
        }
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.CLICK) {
            return new AbstractViewAction(event.name()){

                public void execute(Component view) {
                    Button btn = (Button)view;
                    btn.click();
                }
            };
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "imageButton";
    }
}

