/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.abstractfactory.common.ImageUtils;
import net.abstractfactory.common.OgnlLocator;
import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.input.value.MemoryFile;
import net.abstractfactory.plum.input.value.image.Image;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.ImageBox;
import net.abstractfactory.plum.view.component.attribute.Length;
import net.abstractfactory.plum.view.component.attribute.LengthUnit;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.jsoup.nodes.Element;

public class WebImageBox
extends AbstractTemplateWebComponent {
    private static Element componentHtmlTemplate;
    private final String IMAGE = "image";
    Element imageElement;

    public WebImageBox(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private ImageBox getImageView() {
        return (ImageBox)this.getComponent();
    }

    @Override
    public void writeFile(HttpServletRequest req, HttpServletResponse response, String shortName) throws IOException {
        File file;
        Image image = (Image)this.getImageView().getData();
        if (image == null) {
            return;
        }
        String strWidth = req.getParameter("width");
        String strHeight = req.getParameter("height");
        if (strWidth != null && strHeight != null) {
            BufferedImage image2 = ImageIO.read(image.getFile().getInputStream());
            int width = Integer.parseInt(strWidth);
            int height = Integer.parseInt(strHeight);
            BufferedImage image3 = ImageUtils.scale((BufferedImage)image2, (int)width, (int)height);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image3, "jpg", baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            file = new MemoryFile(imageInByte);
        } else {
            file = image.getFile();
        }
        this.writeFile(response, file);
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.imageElement = this.htmlOuterElement;
        ImageBox imageView = this.getImageView();
        this.imageElement.attr("id", this.id);
        this.imageElement.attr("version", imageView.getDataVersionAsString());
        this.imageElement.removeAttr("alt");
        imageView.getDataVersion();
        if (imageView.getData() != null) {
            String url;
            OgnlLocator locator = ((Image)imageView.getData()).getLocator();
            if (this.isStaticResource() && locator != null) {
                url = WebFileUtils.generateUrl(locator);
            } else {
                Length width = imageView.getWidth();
                Length height = imageView.getHeight();
                url = width != null && height != null && width.getUnit() == LengthUnit.PIXEL && height.getUnit() == LengthUnit.PIXEL ? WebFileUtils.generateImageUrl(this.getId(), "image", imageView.getDataVersionAsString(), width.getSize(), height.getSize()) : WebFileUtils.generateUrl(this.getId(), "image", imageView.getDataVersionAsString());
            }
            this.imageElement.attr("src", url);
        }
    }

    protected ViewAction onValueChange(final Image newValue) {
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                WebImageBox.this.getImageView().setData((Object)newValue, true);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            Image newValue = (Image)parameters.get("image");
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "image";
    }
}

