/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.FileView;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.jsoup.nodes.Element;

public class WebFileField
extends AbstractTemplateWebComponent {
    private static Element componentHtmlTemplate;
    private final String INPUT = "input";
    private final String LINK = "link";
    Element inputElement;
    Element linkElement;

    public WebFileField(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private FileView getFile() {
        return (FileView)this.getComponent();
    }

    @Override
    public void writeFile(HttpServletRequest req, HttpServletResponse response, String shortName) throws IOException {
        File file = this.getFile().getValue();
        this.writeFile(response, file);
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), false);
        this.htmlOuterElement = componentElements.getOuter();
        this.inputElement = this.findElementByClass("input");
        this.inputElement.attr("id", this.id);
        this.inputElement.attr("name", this.getFullInputName("input"));
        this.linkElement = this.findElementByClass("link");
        this.linkElement.attr("href", WebFileUtils.generateUrl(this.getId(), "file"));
        if (this.getFile().getValue() == null) {
            this.linkElement.addClass("hide");
        }
    }

    protected ViewAction onValueChange(final File newValue) {
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                WebFileField.this.getFile().setValue(newValue, true);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            File newValue = this.getParameterAsFile(parameters, "input");
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "file";
    }
}

