/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.ViewOption;
import net.abstractfactory.plum.view.component.listbox.DropdownList;
import net.abstractfactory.plum.view.component.listbox.Options;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;

public class WebDropdownList
extends AbstractWebComponent {
    public static final String VALUE_CHANGE = "valueChange";
    private final String INPUT_NAME = "select";
    private Element select;
    private List<ViewOption> optionList;
    private int selectedIndex = -1;

    public WebDropdownList(String id, Component component) {
        super(id, component);
    }

    protected DropdownList getDropdownList() {
        return (DropdownList)this.component;
    }

    @Override
    public void createHtmlElement() {
        DropdownList dlist = this.getDropdownList();
        this.optionList = new ArrayList<ViewOption>();
        Options inputOptions = dlist.getOptions();
        for (int i = 0; i < inputOptions.size(); ++i) {
            String str;
            Object obj = inputOptions.get(i);
            String value = str = obj == null ? "" : obj.toString();
            String text = str;
            ViewOption option = new ViewOption(value, text);
            this.optionList.add(option);
        }
        this.selectedIndex = dlist.getSelectedIndex();
        this.select = new Element(Tag.valueOf((String)"select"), "");
        this.select.attr("id", this.id);
        this.select.attr("name", this.getFullInputName("select"));
        this.createOptionElements(this.select);
        if (this.getDropdownList().containsListener(VALUE_CHANGE)) {
            String onChange = String.format("_plum_post('%s','%s','%s')", this.getId(), "select", WebEvent.VALUE_SET.name());
            this.select.attr("onChange", onChange);
        }
        this.htmlOuterElement = this.select;
        this.htmlInnerElement = null;
    }

    private void createOptionElements(Element select) {
        for (int i = 0; i < this.optionList.size(); ++i) {
            ViewOption option = this.optionList.get(i);
            Element optionElement = new Element(Tag.valueOf((String)"option"), "");
            optionElement.attr("value", option.getValue());
            optionElement.appendText(option.getText());
            if (i == this.selectedIndex) {
                optionElement.attr("selected", "selected");
            }
            select.appendChild((Node)optionElement);
        }
    }

    protected ViewAction onValueChange(String newValue) {
        boolean stateChanged;
        int oldSelectedIndex = this.selectedIndex;
        int newSelectedIndex = -1;
        for (int i = 0; i < this.optionList.size(); ++i) {
            ViewOption si = this.optionList.get(i);
            if (!si.getValue().equals(newValue)) continue;
            newSelectedIndex = i;
            break;
        }
        boolean bl = stateChanged = oldSelectedIndex != newSelectedIndex;
        if (stateChanged) {
            this.selectedIndex = newSelectedIndex;
        }
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                if (stateChanged) {
                    DropdownList dropdownList = (DropdownList)view;
                    dropdownList.setSelectedIndex(WebDropdownList.this.selectedIndex, true);
                }
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            String newValue = (String)parameters.get("select");
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }
}

