/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import net.abstractfactory.common.ObjectHolder;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.DateTimePicker;
import net.abstractfactory.plum.view.component.DateTimePickerMode;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;

public class WebDateTimePicker
extends AbstractTemplateWebComponent {
    static Logger logger = Logger.getLogger(WebDateTimePicker.class);
    private static Element componentHtmlTemplate;
    private final String INPUT = "input";
    private Element text;
    private String format = this.getDateTimePicker().getFormat();
    private String webFormat = this.toWebFormat(this.format);
    private DateTimePickerMode mode = this.getDateTimePicker().getMode();

    public WebDateTimePicker(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private String toWebFormat(String format) {
        return format.replaceAll("y", "Y").replaceAll("d", "D");
    }

    public DateTimePicker getDateTimePicker() {
        return (DateTimePicker)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        DateTimePicker dateTimePicker;
        String dateStr;
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.text = this.findElementByClass("input");
        this.text.attr("id", this.id);
        this.text.attr("date-format", this.webFormat);
        if (this.mode == DateTimePickerMode.DATE) {
            this.text.attr("data-pick-time", "false");
        } else if (this.mode == DateTimePickerMode.TIME) {
            this.text.attr("data-pick-date", "false");
        }
        this.text.attr("name", this.getFullInputName("input"));
        if (this.getDateTimePicker().containsListener("valueChange")) {
            String onChange = String.format("_plum_post('%s','%s','%s')", this.getId(), "input", WebEvent.VALUE_SET.name());
            this.text.attr("onChange", onChange);
        }
        if ((dateStr = (dateTimePicker = this.getDateTimePicker()).getDateTimeString()) == null) {
            dateStr = "";
        }
        this.text.attr("value", dateStr);
    }

    protected ViewAction onValueChange(String newValue) {
        Date dateTime;
        this.text.attr("value", newValue);
        final ObjectHolder dateTimeHolder = new ObjectHolder();
        SimpleDateFormat sdf = new SimpleDateFormat(this.format);
        try {
            dateTime = sdf.parse(newValue);
        }
        catch (ParseException e) {
            dateTime = null;
        }
        dateTimeHolder.setObject((Object)dateTime);
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                DateTimePicker picker = (DateTimePicker)view;
                picker.setDatetime((Date)dateTimeHolder.getObject(), true);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            String newValue = (String)parameters.get("input");
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "DateTimePicker";
    }
}

