/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;
import net.abstractfactory.plum.view.component.CheckBox;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;

public class WebCheckBox
extends AbstractTemplateWebComponent {
    static Logger logger = Logger.getLogger(WebCheckBox.class);
    private final String LABEL = "label";
    private final String CHECKBOX = "input";
    private static Element componentHtmlTemplate;
    Element checkboxElement;
    Element spanElement;

    public WebCheckBox(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    public CheckBox getCheckBox() {
        return (CheckBox)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.checkboxElement = this.findElementByClass("input");
        this.checkboxElement.attr("id", this.id);
        this.checkboxElement.attr("name", this.getFullInputName("input"));
        if (this.getCheckBox().containsListener("valueChange")) {
            String onChange = String.format("_plum_post('%s','%s','%s')", this.getId(), "input", WebEvent.VALUE_SET.name());
            this.checkboxElement.attr("onChange", onChange);
        }
        this.spanElement = this.findElementByClass("label");
        CheckBox checkBox = this.getCheckBox();
        if (checkBox.isChecked().booleanValue()) {
            this.checkboxElement.attr("checked", "checked");
        } else {
            this.checkboxElement.removeAttr("checked");
        }
        this.spanElement.empty();
        String caption = checkBox.getCaption();
        if (caption == null) {
            caption = "";
        }
        this.spanElement.appendText(caption);
    }

    public boolean isChecked() {
        return this.checkboxElement.hasAttr("checked");
    }

    protected ViewAction onValueChange(String newValue) {
        boolean stateChanged;
        boolean oldState = this.isChecked();
        boolean newState = newValue != null;
        boolean bl = stateChanged = oldState != newState;
        if (stateChanged) {
            if (newState) {
                this.checkboxElement.attr("checked", "checked");
            } else {
                this.checkboxElement.removeAttr("checked");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("component id (%s) state from %s to %s", this.getId(), oldState, newState));
            }
        }
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                if (stateChanged) {
                    CheckBox cb = (CheckBox)view;
                    cb.setChecked(WebCheckBox.this.checkboxElement.hasAttr("checked"), true);
                }
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            String newValue = (String)parameters.get("input");
            return this.onValueChange(newValue);
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "checkbox";
    }
}

