/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;
import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.nodes.Element;

public class WebButton
extends AbstractTemplateWebComponent {
    private static Element componentHtmlTemplate;
    private final String BUTTON = "button";
    Element buttonElement;

    public WebButton(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private Button getButton() {
        return (Button)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.buttonElement = this.htmlOuterElement;
        String caption = this.null2Empty(this.getComponent().getCaption());
        caption = StringEscapeUtils.escapeHtml4((String)caption);
        this.buttonElement.appendText(caption);
        this.applyEvents(this.buttonElement, "button", "click");
        this.buttonElement.attr("name", this.getFullInputName("button"));
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.CLICK) {
            return new AbstractViewAction(event.name()){

                public void execute(Component view) {
                    Button btn = (Button)view;
                    btn.click();
                }
            };
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "button";
    }
}

