/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.abstractfactory.plum.input.value.audio.Audio;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.audiobox.AudioBox;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class WebAudioBox
extends AbstractTemplateWebComponent {
    private static Element componentHtmlTemplate;
    private final String INPUT_NAME = "audio";
    private Element audioElement;
    private Element source;

    public WebAudioBox(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private AudioBox getAudiobox() {
        return (AudioBox)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), false);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.source = this.htmlInnerElement.getElementsByClass("audio-source").first();
        this.source.remove();
        this.htmlInnerElement.empty();
        this.audioElement = this.htmlOuterElement;
        AudioBox audioBox = this.getAudiobox();
        if (audioBox.isShowControls()) {
            this.audioElement.attr("controls", "controls");
        } else {
            this.audioElement.removeAttr("controls");
        }
        if (audioBox.isAutoPlay()) {
            this.audioElement.attr("autoplay", "autoplay");
        }
        if (audioBox.isMuted()) {
            this.audioElement.attr("muted", "muted");
        }
        if (audioBox.isLoop()) {
            this.audioElement.attr("loop", "loop");
        }
        this.source.attr("src", WebFileUtils.generateUrl(this.getId(), "audio", audioBox.getDataVersionAsString()));
        Audio audio = (Audio)audioBox.getData();
        if (audio != null) {
            this.source.attr("type", ((Audio)audioBox.getData()).getFile().getContentType());
        }
        if (audioBox.containsListener("ended")) {
            String onEnded = String.format("_plum_post('%s','%s','%s','');", this.getId(), "audio", WebEvent.ENDED.name());
            this.audioElement.attr("onEnded", onEnded);
        }
        this.htmlInnerElement.appendChild((Node)this.source);
        this.htmlInnerElement.appendText("Your browser not support audio element");
    }

    @Override
    public void writeFile(HttpServletRequest req, HttpServletResponse response, String shortName) throws IOException {
        Audio audio = (Audio)this.getAudiobox().getData();
        if (audio != null) {
            this.writeFile(response, audio.getFile());
        }
    }

    protected ViewAction onValueChange(String newValue) {
        return new AbstractViewAction(WebEvent.VALUE_SET.name()){

            public void execute(Component view) {
                AudioBox box = (AudioBox)view;
            }
        };
    }

    protected ViewAction onEnded() {
        return new AbstractViewAction(WebEvent.ENDED.name()){

            public void execute(Component view) {
                AudioBox box = (AudioBox)view;
                box.notifyEventListeners("ended");
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.VALUE_SET) {
            String newValue = (String)parameters.get("audio");
            return this.onValueChange(newValue);
        }
        if (event == WebEvent.ENDED) {
            return this.onEnded();
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "audiobox";
    }
}

