/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.container.window.dialog;

import java.util.Map;
import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.builder.AbstractConditionBuilder;
import net.abstractfactory.plum.view.web.component.builder.ConditionalComponentBuilderCollection;
import net.abstractfactory.plum.view.web.component.builder.WebViewBuilder;
import org.jsoup.nodes.Element;

public class WebDialogCloseButton
extends AbstractTemplateWebComponent {
    private static Element componentHtmlTemplate;
    private final String BUTTON = "button";
    Element buttonElement;

    public WebDialogCloseButton(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    private Button getButton() {
        return (Button)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.buttonElement = this.htmlOuterElement;
        this.buttonElement.appendText(this.null2Empty(this.getComponent().getCaption()));
        String onclick = String.format("_plum_post('%s','%s','click')", this.getId(), "button");
        this.buttonElement.attr("onclick", onclick);
        if (this.getButton().isDisabled()) {
            this.buttonElement.attr("disabled", "disabled");
        }
        this.buttonElement.attr("name", this.getFullInputName("button"));
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.CLICK) {
            return new AbstractViewAction(event.name()){

                public void execute(Component view) {
                    Button btn = (Button)view;
                    btn.click();
                }
            };
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "dialogCloseButton";
    }

    public static void registerBuilder(ConditionalComponentBuilderCollection collection) {
        collection.add(new ComponentBuilder());
    }

    private static class ComponentBuilder
    extends AbstractConditionBuilder {
        private ComponentBuilder() {
        }

        @Override
        public Class getComponentClass() {
            return Button.class;
        }

        @Override
        public boolean isMatch(Component component) {
            boolean nameResult = this.checkNames(component, "closeButton");
            if (nameResult) {
                boolean checkClass = this.checkClasses(component, Button.class, Panel.class, Dialog.class);
                return checkClass;
            }
            return false;
        }

        @Override
        public WebComponent visit(WebViewBuilder builder, Component component) {
            return builder.commonVisitWithoutPreprocess(WebDialogCloseButton.class, component);
        }
    }
}

