/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.container.window.dialog;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.web.CSSAttributes;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import net.abstractfactory.plum.view.web.component.builder.ConditionalComponentBuilderCollection;
import net.abstractfactory.plum.view.web.component.container.window.dialog.WebDialogContentPanel;
import net.abstractfactory.plum.view.web.component.container.window.dialog.WebDialogTitlePanel;
import org.jsoup.nodes.Element;

public class WebDialog
extends AbstractTemplateWebComponent {
    private static Element componentHtmlTemplate;
    private Element middleElement;
    private Element titleElement;
    private String title;

    public WebDialog(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
        Window window = (Window)component;
        this.title = window.getTitle();
    }

    protected Dialog getDialog() {
        return (Dialog)this.component;
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.middleElement = this.findElementByClass("middle");
        this.htmlInnerElement = componentElements.getInner();
        String styleContent = this.htmlOuterElement.attr("style");
        CSSAttributes style = new CSSAttributes(styleContent);
        style.set("display", "block");
        this.htmlOuterElement.attr("style", style.toCssText());
    }

    @Override
    public void init() {
        this.createHtmlElement();
        this.updateIdInHtml(this.id);
        CSSAttributes attrs = this.createCommonStyles();
        this.applyStyle(this.middleElement, attrs);
        if (this.getComponent().isDisabled()) {
            this.htmlOuterElement.attr("disabled", "disabled");
        }
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "dialog";
    }

    public static void registerBuilder(ConditionalComponentBuilderCollection collection) {
        WebDialogTitlePanel.registerBuilder(collection);
        WebDialogContentPanel.registerBuilder(collection);
    }
}

