/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.builder;

import java.lang.reflect.Constructor;
import java.util.List;
import net.abstractfactory.common.ListValueMap;
import net.abstractfactory.common.TreeNode;
import net.abstractfactory.plum.view.ComponentVisitor;
import net.abstractfactory.plum.view.client.ViewSyncMode;
import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.CheckBox;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.DateTimePicker;
import net.abstractfactory.plum.view.component.FilePicker;
import net.abstractfactory.plum.view.component.FileView;
import net.abstractfactory.plum.view.component.HyperLink;
import net.abstractfactory.plum.view.component.ImageBox;
import net.abstractfactory.plum.view.component.ImageButton;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.component.ListBox;
import net.abstractfactory.plum.view.component.ListItemView;
import net.abstractfactory.plum.view.component.ListView;
import net.abstractfactory.plum.view.component.RadioBox;
import net.abstractfactory.plum.view.component.RadioItem;
import net.abstractfactory.plum.view.component.SpinBox;
import net.abstractfactory.plum.view.component.TextArea;
import net.abstractfactory.plum.view.component.TextBox;
import net.abstractfactory.plum.view.component.VideoBox;
import net.abstractfactory.plum.view.component.audiobox.AudioBox;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.component.containers.window.Screen;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.component.grid.Cell;
import net.abstractfactory.plum.view.component.grid.Grid;
import net.abstractfactory.plum.view.component.grid.Row;
import net.abstractfactory.plum.view.component.id.IdGenerationType;
import net.abstractfactory.plum.view.component.id.IdGenerator;
import net.abstractfactory.plum.view.component.id.IdGeneratorFactory;
import net.abstractfactory.plum.view.component.listbox.DropdownList;
import net.abstractfactory.plum.view.component.menu.Menu;
import net.abstractfactory.plum.view.component.menu.MenuBar;
import net.abstractfactory.plum.view.component.menu.MenuItem;
import net.abstractfactory.plum.view.component.tab.Tab;
import net.abstractfactory.plum.view.component.tab.Tabs;
import net.abstractfactory.plum.view.component.tree.TreeNodeView;
import net.abstractfactory.plum.view.component.tree.TreeView;
import net.abstractfactory.plum.view.component.web.HtmlView;
import net.abstractfactory.plum.view.event.EventListener;
import net.abstractfactory.plum.view.layout.Box;
import net.abstractfactory.plum.view.layout.GridLayout;
import net.abstractfactory.plum.view.layout.HorizontalBox;
import net.abstractfactory.plum.view.layout.VerticalBox;
import net.abstractfactory.plum.view.web.WebPageView;
import net.abstractfactory.plum.view.web.WebTemplatePage;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.WebHyperLink;
import net.abstractfactory.plum.view.web.component.WebLabel;
import net.abstractfactory.plum.view.web.component.WebPanel;
import net.abstractfactory.plum.view.web.component.WebTab;
import net.abstractfactory.plum.view.web.component.WebTabs;
import net.abstractfactory.plum.view.web.component.builder.ConditionalComponentBuilderCollection;
import net.abstractfactory.plum.view.web.component.builder.ConditionalWebComponentBuilder;
import net.abstractfactory.plum.view.web.component.builder.WebComponentFactory;
import net.abstractfactory.plum.view.web.component.container.WebScreen;
import net.abstractfactory.plum.view.web.component.container.window.WebMainWindowTitlePanel;
import net.abstractfactory.plum.view.web.component.container.window.WebWindow;
import net.abstractfactory.plum.view.web.component.container.window.dialog.WebDialog;
import net.abstractfactory.plum.view.web.component.grid.WebCell;
import net.abstractfactory.plum.view.web.component.grid.WebGrid;
import net.abstractfactory.plum.view.web.component.grid.WebRow;
import net.abstractfactory.plum.view.web.component.input.WebAudioBox;
import net.abstractfactory.plum.view.web.component.input.WebButton;
import net.abstractfactory.plum.view.web.component.input.WebCheckBox;
import net.abstractfactory.plum.view.web.component.input.WebDateTimePicker;
import net.abstractfactory.plum.view.web.component.input.WebDropdownList;
import net.abstractfactory.plum.view.web.component.input.WebFileField;
import net.abstractfactory.plum.view.web.component.input.WebFilePicker;
import net.abstractfactory.plum.view.web.component.input.WebImageBox;
import net.abstractfactory.plum.view.web.component.input.WebImageButton;
import net.abstractfactory.plum.view.web.component.input.WebListBox;
import net.abstractfactory.plum.view.web.component.input.WebRadioBox;
import net.abstractfactory.plum.view.web.component.input.WebRadioItem;
import net.abstractfactory.plum.view.web.component.input.WebSpinBox;
import net.abstractfactory.plum.view.web.component.input.WebTextArea;
import net.abstractfactory.plum.view.web.component.input.WebTextBox;
import net.abstractfactory.plum.view.web.component.input.WebVideoBox;
import net.abstractfactory.plum.view.web.component.listview.WebHListView;
import net.abstractfactory.plum.view.web.component.listview.WebHListViewItem;
import net.abstractfactory.plum.view.web.component.listview.WebVListView;
import net.abstractfactory.plum.view.web.component.listview.WebVListViewItem;
import net.abstractfactory.plum.view.web.component.menu.WebMenu;
import net.abstractfactory.plum.view.web.component.menu.WebMenuBar;
import net.abstractfactory.plum.view.web.component.menu.WebMenuItem;
import net.abstractfactory.plum.view.web.component.menu.WebSubMenu;
import net.abstractfactory.plum.view.web.component.tree.WebTreeNodeView;
import net.abstractfactory.plum.view.web.component.tree.WebTreeView;
import net.abstractfactory.plum.view.web.component.web.WebHtmlView;
import net.abstractfactory.plum.view.web.layout.WebBox;
import net.abstractfactory.plum.view.web.layout.WebGridLayout;
import net.abstractfactory.plum.view.web.layout.WebTableHBox;
import net.abstractfactory.plum.view.web.layout.WebTableVBox;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;

public class WebViewBuilder
implements ComponentVisitor<WebComponent>,
ConditionalComponentBuilderCollection {
    private static Logger logger = Logger.getLogger(WebViewBuilder.class);
    private static String PAGE_FILE = "template-bootstrap.html";
    private WebTemplatePage templatePage;
    private ListValueMap<Class, ConditionalWebComponentBuilder> componentBuilderMap = new ListValueMap();
    private WebPageView webView;
    private EventListener nonUserCausedViewChangeEventListener;
    private static long version = 0L;
    private IdGenerationType idGenerationType;
    private boolean staticResource;

    public WebViewBuilder(String topic, EventListener nonUserCausedViewChangeEventListener, IdGenerationType idGenerationType) {
        this.nonUserCausedViewChangeEventListener = nonUserCausedViewChangeEventListener;
        this.idGenerationType = idGenerationType;
        WebDialog.registerBuilder(this);
        WebMainWindowTitlePanel.registerBuilder(this);
    }

    public synchronized WebPageView build(Component rootComponent, Component activeComponent, String title, String pushTopic, ViewSyncMode viewSyncMode, boolean increaseVersion) {
        this.staticResource = viewSyncMode == ViewSyncMode.POST_REDIRECT_GET;
        this.templatePage = new WebTemplatePage(PAGE_FILE);
        this.webView = new WebPageView(this.templatePage.getDocument().clone(), pushTopic, viewSyncMode);
        WebComponent rootWebComponent = (WebComponent)rootComponent.accept((ComponentVisitor)this);
        this.webView.setRootContentWebComponent(rootWebComponent, title);
        if (activeComponent != null) {
            this.webView.setActiveElementId(activeComponent.getId());
        }
        String ver = increaseVersion ? this.getNextVersion() : this.getCurrentVersion();
        this.webView.setVersion(ver);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("build web view:" + this.webView + " version:" + version));
        }
        return this.webView;
    }

    private String getCurrentVersion() {
        return String.format("%d", version);
    }

    private String getNextVersion() {
        return String.format("%d", ++version);
    }

    private void addComponentToMap(Component abstractComp, WebComponent webComp) {
        this.webView.getWebComponentMap().put(webComp.getId(), webComp);
        this.webView.getComponentToWebComponentMap().put(abstractComp, webComp);
        if (webComp instanceof WebCheckBox) {
            this.webView.getWebCheckBoxMap().put(webComp.getId(), (WebCheckBox)webComp);
        }
    }

    protected void visitChildren(WebComponent htmlParent, Component uicomponent) {
        for (TreeNode node : uicomponent.getChildren()) {
            Component comp = (Component)node;
            AbstractWebComponent htmlComp = (AbstractWebComponent)comp.accept((ComponentVisitor)this);
            if (htmlComp == null) {
                throw new RuntimeException("web component not created:" + comp.getClass().getSimpleName());
            }
            htmlParent.addChild(htmlComp);
        }
    }

    public WebComponent visit(Component component) {
        return WebComponentFactory.getInstace().create(this, component);
    }

    public WebComponent visit(TextBox component) {
        return this.commonVisit(WebTextBox.class, TextBox.class, (Component)component);
    }

    public WebComponent visit(TextArea component) {
        return this.commonVisit(WebTextArea.class, TextArea.class, (Component)component);
    }

    public WebComponent visit(CheckBox component) {
        return this.commonVisit(WebCheckBox.class, CheckBox.class, (Component)component);
    }

    public WebComponent visit(RadioBox component) {
        return this.commonVisit(WebRadioBox.class, RadioBox.class, (Component)component);
    }

    public WebComponent visit(RadioItem component) {
        return this.commonVisit(WebRadioItem.class, RadioItem.class, (Component)component);
    }

    public WebComponent visit(FilePicker component) {
        return this.commonVisit(WebFilePicker.class, FilePicker.class, (Component)component);
    }

    public WebComponent visit(FileView component) {
        return this.commonVisit(WebFileField.class, FileView.class, (Component)component);
    }

    public WebComponent visit(ImageBox component) {
        return this.commonVisit(WebImageBox.class, ImageBox.class, (Component)component);
    }

    public WebComponent visit(AudioBox component) {
        return this.commonVisit(WebAudioBox.class, AudioBox.class, (Component)component);
    }

    public WebComponent visit(VideoBox component) {
        return this.commonVisit(WebVideoBox.class, VideoBox.class, (Component)component);
    }

    public WebComponent visit(DateTimePicker component) {
        return this.commonVisit(WebDateTimePicker.class, DateTimePicker.class, (Component)component);
    }

    public WebComponent visit(SpinBox component) {
        return this.commonVisit(WebSpinBox.class, SpinBox.class, (Component)component);
    }

    public WebComponent visit(Button component) {
        return this.commonVisit(WebButton.class, Button.class, (Component)component);
    }

    public WebComponent visit(ImageButton component) {
        return this.commonVisit(WebImageButton.class, ImageButton.class, (Component)component);
    }

    public WebComponent visit(Label component) {
        return this.commonVisit(WebLabel.class, Label.class, (Component)component);
    }

    public WebComponent visit(DropdownList component) {
        return this.commonVisit(WebDropdownList.class, DropdownList.class, (Component)component);
    }

    public WebComponent visit(ListBox component) {
        return this.commonVisit(WebListBox.class, ListBox.class, (Component)component);
    }

    public WebComponent visit(Screen component) {
        return this.commonVisit(WebScreen.class, Screen.class, (Component)component);
    }

    public WebComponent visit(Window component) {
        return this.commonVisit(WebWindow.class, Window.class, (Component)component);
    }

    public WebComponent visit(Dialog component) {
        return this.commonVisit(WebDialog.class, Dialog.class, (Component)component);
    }

    public WebComponent visit(Grid component) {
        return this.commonVisit(WebGrid.class, Grid.class, (Component)component);
    }

    public WebComponent visit(Row component) {
        return this.commonVisit(WebRow.class, Row.class, (Component)component);
    }

    public WebComponent visit(Cell component) {
        return this.commonVisit(WebCell.class, Cell.class, (Component)component);
    }

    public WebComponent visit(ListView component) {
        WebComponent wc = component.getDirection() == ListView.Direction.HORIZONTAL ? this.commonVisit(WebHListView.class, ListView.class, (Component)component) : this.commonVisit(WebVListView.class, ListView.class, (Component)component);
        return wc;
    }

    public WebComponent visit(ListItemView component) {
        ListView listView = (ListView)component.getParentComponent();
        WebComponent wc = listView.getDirection() == ListView.Direction.HORIZONTAL ? this.commonVisit(WebHListViewItem.class, ListItemView.class, (Component)component) : this.commonVisit(WebVListViewItem.class, ListItemView.class, (Component)component);
        return wc;
    }

    public WebComponent visit(GridLayout component) {
        return this.commonVisit(WebGridLayout.class, GridLayout.class, (Component)component);
    }

    public WebComponent visit(Box component) {
        return this.commonVisit(WebBox.class, Box.class, (Component)component);
    }

    public WebComponent visit(HorizontalBox component) {
        return this.commonVisit(WebTableHBox.class, HorizontalBox.class, (Component)component);
    }

    public WebComponent visit(VerticalBox component) {
        return this.commonVisit(WebTableVBox.class, VerticalBox.class, (Component)component);
    }

    public WebComponent visit(MenuBar component) {
        return this.commonVisit(WebMenuBar.class, MenuBar.class, (Component)component);
    }

    public WebComponent visit(Menu component) {
        this.setIdIfNull((Component)component);
        int depth = component.getMenuDepth();
        AbstractTemplateWebComponent awc = depth == 1 ? new WebMenu(component.getId(), (Component)component, (Element)this.templatePage.getDocument()) : new WebSubMenu(component.getId(), (Component)component, (Element)this.templatePage.getDocument());
        awc.init();
        this.addComponentToMap((Component)component, awc);
        String hashOfOwn = awc.calcHash();
        awc.setOwnHash(hashOfOwn);
        this.visitChildren(awc, (Component)component);
        String hashOfChilren = awc.calcHashOfChildrenId();
        awc.setChildrenIdsHash(DigestUtils.md5Hex((String)hashOfChilren));
        return awc;
    }

    public WebComponent visit(MenuItem component) {
        return this.commonVisit(WebMenuItem.class, MenuItem.class, (Component)component);
    }

    public WebComponent visit(HyperLink component) {
        return this.commonVisit(WebHyperLink.class, HyperLink.class, (Component)component);
    }

    public WebComponent visit(HtmlView component) {
        return this.commonVisit(WebHtmlView.class, HtmlView.class, (Component)component);
    }

    public WebComponent visit(Panel component) {
        this.setIdIfNull((Component)component);
        return this.commonVisit(WebPanel.class, Panel.class, (Component)component);
    }

    public WebComponent visit(Tab component) {
        return this.commonVisit(WebTab.class, Tab.class, (Component)component);
    }

    public WebComponent visit(Tabs component) {
        return this.commonVisit(WebTabs.class, Tabs.class, (Component)component);
    }

    public WebComponent visit(TreeNodeView component) {
        return this.commonVisit(WebTreeNodeView.class, TreeNodeView.class, (Component)component);
    }

    public WebComponent visit(TreeView component) {
        return this.commonVisit(WebTreeView.class, TreeView.class, (Component)component);
    }

    public WebComponent commonVisitWithoutPreprocess(Class<? extends WebComponent> webComponentClass, Component component) {
        return this.commonVisit(webComponentClass, null, component, false);
    }

    protected WebComponent commonVisit(Class<? extends WebComponent> webComponentClass, Class<? extends Component> componentClass, Component component) {
        return this.commonVisit(webComponentClass, componentClass, component, true);
    }

    private void setIdIfNull(Component component) {
        if (component.getId() == null) {
            IdGenerator idGenerator = IdGeneratorFactory.getGenerator((IdGenerationType)this.idGenerationType);
            String id = idGenerator.generate(component);
            component.setId(id);
        }
    }

    private WebComponent commonVisit(Class<? extends WebComponent> webComponentClass, Class<? extends Component> componentClass, Component component, boolean preprocess) {
        WebComponent wc;
        this.setIdIfNull(component);
        if (preprocess && (wc = this.preprocess(componentClass, component)) != null) {
            return wc;
        }
        AbstractWebComponent awc = this.newComponent(webComponentClass, component.getId(), component);
        awc.setStaticResource(this.staticResource);
        awc.init();
        if (!component.existsEventListener("nonUserCausedViewChange", this.nonUserCausedViewChangeEventListener)) {
            component.addEventListener("nonUserCausedViewChange", this.nonUserCausedViewChangeEventListener);
        }
        this.addComponentToMap(component, awc);
        String hashOfOwn = awc.calcHash();
        awc.setOwnHash(hashOfOwn);
        this.visitChildren(awc, component);
        String hashOfChilren = awc.calcHashOfChildrenId();
        awc.setChildrenIdsHash(DigestUtils.md5Hex((String)hashOfChilren));
        return awc;
    }

    protected AbstractWebComponent newComponent(Class clazz, String id, Component abstractComponent) {
        try {
            if (AbstractTemplateWebComponent.class.isAssignableFrom(clazz)) {
                Constructor ctor = clazz.getConstructor(String.class, Component.class, Element.class);
                return (AbstractWebComponent)ctor.newInstance(id, abstractComponent, this.templatePage.getDocument());
            }
            Constructor ctor = clazz.getConstructor(String.class, Component.class);
            return (AbstractWebComponent)ctor.newInstance(id, abstractComponent);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    WebComponent preprocess(Class<? extends Component> clazz, Component component) {
        WebComponent clientComp = null;
        List list = this.componentBuilderMap.get(clazz);
        if (list == null) {
            return null;
        }
        ConditionalWebComponentBuilder candidate = null;
        int count = 0;
        for (ConditionalWebComponentBuilder componentBuilder : list) {
            if (!componentBuilder.isMatch(component)) continue;
            candidate = componentBuilder;
            ++count;
        }
        if (count > 1) {
            throw new RuntimeException("only one component builder should be matched");
        }
        if (count == 1) {
            clientComp = candidate.visit(this, component);
        }
        return clientComp;
    }

    @Override
    public void add(ConditionalWebComponentBuilder componentBuilder) {
        this.componentBuilderMap.add((Object)componentBuilder.getComponentClass(), (Object)componentBuilder);
    }
}

