/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.builder;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.builder.WebComponentBuilder;
import net.abstractfactory.plum.view.web.component.builder.WebViewBuilder;
import net.abstractfactory.util.ReflectionFactory;
import net.abstractfactory.util.ReflectionHelper;
import org.apache.log4j.Logger;

public class WebComponentFactory {
    private static Logger logger = Logger.getLogger(WebComponentFactory.class);
    private static WebComponentFactory instance;
    private Set<String> builderBasePackages;
    private Map<Class, WebComponentBuilder> builders = new HashMap<Class, WebComponentBuilder>();

    public static void init(Set<String> builderBasePackages) {
        instance = new WebComponentFactory(builderBasePackages);
    }

    public static WebComponentFactory getInstace() {
        if (instance == null) {
            instance = new WebComponentFactory(new HashSet<String>());
        }
        return instance;
    }

    private WebComponentFactory(Set<String> builderBasePackages) {
        this.builderBasePackages = builderBasePackages;
        if (builderBasePackages.isEmpty()) {
            builderBasePackages.add("net.abstractfactory.plum.lib.extra");
        }
        this.scan(builderBasePackages);
    }

    public Set<String> getBuilderBasePackages() {
        return this.builderBasePackages;
    }

    public void setBuilderBasePackages(Set<String> builderBasePackages) {
        this.builderBasePackages = builderBasePackages;
    }

    private void scan(Set<String> basePackages) {
        Set scanResult = new HashSet();
        for (String basePackage : basePackages) {
            ReflectionHelper reflectionHelper = ReflectionFactory.getReflectionHelper();
            scanResult = reflectionHelper.scanClasses(basePackage, WebComponentBuilder.class);
        }
        for (Class builderClass : scanResult) {
            try {
                Class clazz = builderClass;
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
                logger.debug((Object)("find view builder: " + builderClass));
                WebComponentBuilder builder = (WebComponentBuilder)clazz.newInstance();
                this.register(builder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void register(WebComponentBuilder builder) {
        Class componentClass = builder.getComponentClass();
        if (this.builders.containsKey(componentClass)) {
            throw new RuntimeException("web component builder already exist for component class:" + componentClass);
        }
        this.builders.put(componentClass, builder);
    }

    public WebComponent create(WebViewBuilder viewBuilder, Component component) {
        Class<?> componentClass = component.getClass();
        WebComponentBuilder builder = this.builders.get(componentClass);
        if (builder == null) {
            throw new RuntimeException("web component builder not found for component class:" + componentClass.getCanonicalName());
        }
        return builder.visit(viewBuilder, component);
    }
}

