/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component;

import java.util.List;
import java.util.Map;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.tab.Tab;
import net.abstractfactory.plum.view.component.tab.Tabs;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class WebTabs
extends AbstractTemplateWebComponent {
    static Logger logger = Logger.getLogger(WebTabs.class);
    private static final String PARAMETER_INDEX = "index";
    private static Element componentHtmlTemplate;
    private Element header;
    private Element headerItemActive;
    private Element headerItemInactive;
    private Element body;
    private Element bodyItemActive;
    private Element bodyItemInactive;

    public WebTabs(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    public Tabs getTabs() {
        return (Tabs)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        this.header = this.findElementByClass("header");
        this.headerItemActive = this.findElementByClass("header-item-active");
        this.headerItemInactive = this.findElementByClass("header-item-inactive");
        this.body = this.findElementByClass("body");
        this.bodyItemActive = this.findElementByClass("body-item-active");
        this.bodyItemActive = this.findElementByClass("body-item-inactive");
        this.header.empty();
        List items = this.getTabs().getItems();
        int activeIndex = this.getTabs().getActiveIndex();
        for (int i = 0; i < items.size(); ++i) {
            Tab item = (Tab)items.get(i);
            Element headerItem = i == activeIndex ? this.headerItemActive.clone() : this.headerItemInactive.clone();
            Element link = headerItem.getElementsByClass("link").first();
            link.text(item.getCaption());
            String params = String.format("%s=%d", PARAMETER_INDEX, i);
            String onChange = String.format("_plum_post('%s','%s','%s','%s')", this.getId(), "link", WebEvent.CLICK.name().toLowerCase(), params);
            link.attr("onClick", onChange);
            this.header.appendChild((Node)headerItem);
        }
    }

    protected ViewAction onTabChange(final int newIndex) {
        return new AbstractViewAction(WebEvent.CLICK.name()){

            public void execute(Component view) {
                Tabs tabs = (Tabs)view;
                tabs.setActiveTab(newIndex, true);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.CLICK) {
            String strIndex = (String)parameters.get(PARAMETER_INDEX);
            Integer index = Integer.valueOf(strIndex);
            return this.onTabChange(index);
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "Tabs";
    }
}

