/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MultipartFileSender {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private static final int DEFAULT_BUFFER_SIZE = 20480;
    private static final long DEFAULT_EXPIRE_TIME = 604800000L;
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    Path filepath;
    HttpServletRequest request;
    HttpServletResponse response;

    public static MultipartFileSender fromPath(Path path) {
        return new MultipartFileSender().setFilepath(path);
    }

    public static MultipartFileSender fromFile(File file) {
        return new MultipartFileSender().setFilepath(file.toPath());
    }

    public static MultipartFileSender fromURIString(String uri) {
        return new MultipartFileSender().setFilepath(Paths.get(uri, new String[0]));
    }

    private MultipartFileSender setFilepath(Path filepath) {
        this.filepath = filepath;
        return this;
    }

    public MultipartFileSender with(HttpServletRequest httpRequest) {
        this.request = httpRequest;
        return this;
    }

    public MultipartFileSender with(HttpServletResponse httpResponse) {
        this.response = httpResponse;
        return this;
    }

    public void serveResource() throws Exception {
        if (this.response == null || this.request == null) {
            return;
        }
        if (!Files.exists(this.filepath, new LinkOption[0])) {
            this.logger.error((Object)("File doesn't exist at URI : {}" + this.filepath.toAbsolutePath().toString()));
            this.response.sendError(404);
            return;
        }
        Long length = Files.size(this.filepath);
        String fileName = this.filepath.getFileName().toString();
        FileTime lastModifiedObj = Files.getLastModifiedTime(this.filepath, new LinkOption[0]);
        if (StringUtils.isEmpty((CharSequence)fileName) || lastModifiedObj == null) {
            this.response.sendError(500);
            return;
        }
        long lastModified = lastModifiedObj.toMillis();
        String contentType = "video/mp4";
        String ifNoneMatch = this.request.getHeader("If-None-Match");
        if (ifNoneMatch != null && HttpUtils.matches(ifNoneMatch, fileName)) {
            this.response.setHeader("ETag", fileName);
            this.response.sendError(304);
            return;
        }
        long ifModifiedSince = this.request.getDateHeader("If-Modified-Since");
        if (ifNoneMatch == null && ifModifiedSince != -1L && ifModifiedSince + 1000L > lastModified) {
            this.response.setHeader("ETag", fileName);
            this.response.sendError(304);
            return;
        }
        String ifMatch = this.request.getHeader("If-Match");
        if (ifMatch != null && !HttpUtils.matches(ifMatch, fileName)) {
            this.response.sendError(412);
            return;
        }
        long ifUnmodifiedSince = this.request.getDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= lastModified) {
            this.response.sendError(412);
            return;
        }
        Range full = new Range(0L, length - 1L, length);
        ArrayList<Range> ranges = new ArrayList<Range>();
        String range = this.request.getHeader("Range");
        if (range != null) {
            if (!range.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
                this.response.setHeader("Content-Range", "bytes */" + length);
                this.response.sendError(416);
                return;
            }
            String ifRange = this.request.getHeader("If-Range");
            if (ifRange != null && !ifRange.equals(fileName)) {
                try {
                    long ifRangeTime = this.request.getDateHeader("If-Range");
                    if (ifRangeTime != -1L) {
                        ranges.add(full);
                    }
                }
                catch (IllegalArgumentException ignore) {
                    ranges.add(full);
                }
            }
            if (ranges.isEmpty()) {
                for (String part : range.substring(6).split(",")) {
                    long start = Range.sublong(part, 0, part.indexOf("-"));
                    long end = Range.sublong(part, part.indexOf("-") + 1, part.length());
                    if (start == -1L) {
                        start = length - end;
                        end = length - 1L;
                    } else if (end == -1L || end > length - 1L) {
                        end = length - 1L;
                    }
                    if (start > end) {
                        this.response.setHeader("Content-Range", "bytes */" + length);
                        this.response.sendError(416);
                        return;
                    }
                    ranges.add(new Range(start, end, length));
                }
            }
        }
        String disposition = "inline";
        if (contentType == null) {
            contentType = "application/octet-stream";
        } else if (!contentType.startsWith("image")) {
            String accept = this.request.getHeader("Accept");
            disposition = accept != null && HttpUtils.accepts(accept, contentType) ? "inline" : "attachment";
        }
        this.logger.debug((Object)("Content-Type : " + contentType));
        this.response.reset();
        this.response.setBufferSize(20480);
        this.response.setHeader("Content-Type", contentType);
        this.response.setHeader("Content-Disposition", disposition + ";filename=\"" + fileName + "\"");
        this.logger.debug((Object)("Content-Disposition : " + disposition));
        this.response.setHeader("Accept-Ranges", "bytes");
        this.response.setHeader("ETag", fileName);
        this.response.setDateHeader("Last-Modified", lastModified);
        this.response.setDateHeader("Expires", System.currentTimeMillis() + 604800000L);
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(this.filepath, new OpenOption[0]));
             ServletOutputStream output = this.response.getOutputStream();){
            if (ranges.isEmpty() || ranges.get(0) == full) {
                this.logger.info((Object)"Return full file");
                this.response.setContentType(contentType);
                this.response.setHeader("Content-Range", "bytes " + full.start + "-" + full.end + "/" + full.total);
                this.response.setHeader("Content-Length", String.valueOf(full.length));
                Range.copy(input, (OutputStream)output, length, full.start, full.length);
            } else if (ranges.size() == 1) {
                Range r = (Range)ranges.get(0);
                this.logger.info((Object)String.format("Return 1 part of file : from (%d) to (%d)", r.start, r.end));
                this.response.setContentType(contentType);
                this.response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                this.response.setHeader("Content-Length", String.valueOf(r.length));
                this.response.setStatus(206);
                Range.copy(input, (OutputStream)output, length, r.start, r.length);
            } else {
                this.response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                this.response.setStatus(206);
                ServletOutputStream sos = output;
                for (Range r : ranges) {
                    this.logger.info((Object)String.format("Return multi part of file : from (%d) to (%d)", r.start, r.end));
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES");
                    sos.println("Content-Type: " + contentType);
                    sos.println("Content-Range: bytes " + r.start + "-" + r.end + "/" + r.total);
                    Range.copy(input, (OutputStream)output, length, r.start, r.length);
                }
                sos.println();
                sos.println("--MULTIPART_BYTERANGES--");
            }
        }
    }

    private static class HttpUtils {
        private HttpUtils() {
        }

        public static boolean accepts(String acceptHeader, String toAccept) {
            Object[] acceptValues = acceptHeader.split("\\s*(,|;)\\s*");
            Arrays.sort(acceptValues);
            return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, toAccept.replaceAll("/.*$", "/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
        }

        public static boolean matches(String matchHeader, String toMatch) {
            Object[] matchValues = matchHeader.split("\\s*,\\s*");
            Arrays.sort(matchValues);
            return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
        }
    }

    private static class Range {
        long start;
        long end;
        long length;
        long total;

        public Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }

        public static long sublong(String value, int beginIndex, int endIndex) {
            String substring = value.substring(beginIndex, endIndex);
            return substring.length() > 0 ? Long.parseLong(substring) : -1L;
        }

        private static void copy(InputStream input, OutputStream output, long inputSize, long start, long length) throws IOException {
            byte[] buffer = new byte[20480];
            if (inputSize == length) {
                int read;
                while ((read = input.read(buffer)) > 0) {
                    output.write(buffer, 0, read);
                    output.flush();
                }
            } else {
                int read;
                input.skip(start);
                long toRead = length;
                while ((read = input.read(buffer)) > 0) {
                    if ((toRead -= (long)read) > 0L) {
                        output.write(buffer, 0, read);
                        output.flush();
                        continue;
                    }
                    output.write(buffer, 0, (int)toRead + read);
                    output.flush();
                    break;
                }
            }
        }
    }
}

