/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.abstractfactory.common.ListValueMap;
import net.abstractfactory.common.TreeNode;
import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.attribute.Border;
import net.abstractfactory.plum.view.component.attribute.Direction;
import net.abstractfactory.plum.view.component.attribute.Length;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.misc.Color;
import net.abstractfactory.plum.view.misc.Font;
import net.abstractfactory.plum.view.misc.FontWeight;
import net.abstractfactory.plum.view.misc.TextDecoration;
import net.abstractfactory.plum.view.web.CSSAttribute;
import net.abstractfactory.plum.view.web.CSSAttributes;
import net.abstractfactory.plum.view.web.component.WebComponent;
import org.apache.commons.codec.digest.DigestUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public abstract class AbstractWebComponent
extends TreeNode
implements WebComponent {
    protected String id;
    protected Element styleElement;
    protected Element htmlOuterElement;
    protected Element htmlInnerElement;
    protected Component component;
    protected boolean changed = false;
    private String ownHash;
    private String childrenIdsHash;
    private boolean staticResource;

    public AbstractWebComponent(String id, Component component) {
        this.id = id;
        this.component = component;
    }

    public void init() {
        this.createHtmlElement();
        this.updateIdInHtml(this.id);
        CSSAttributes attrs = this.createCommonStyles();
        this.applyStyle(this.htmlOuterElement, attrs);
        if (this.getComponent().isDisabled()) {
            this.htmlOuterElement.attr("disabled", "disabled");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
        this.updateIdInHtml(id);
    }

    protected void updateIdInHtml(String id) {
        if (id != null) {
            this.htmlOuterElement.attr("id", id);
        }
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public abstract void createHtmlElement();

    public Element getStyleElement() {
        return this.styleElement;
    }

    @Override
    public Element getHtmlOuterElement() {
        return this.htmlOuterElement;
    }

    protected Element getHtmlInnerElementForNewChild() {
        return this.htmlInnerElement;
    }

    protected String getFullInputName(String shortName) {
        return String.format("%s_%s", this.getId(), shortName);
    }

    protected String getFullInputName(String id, String shortName) {
        return String.format("%s_%s", id, shortName);
    }

    @Override
    public void addChild(TreeNode node) {
        Element container = this.getHtmlInnerElementForNewChild();
        super.addChild(node);
        WebComponent child = (WebComponent)node;
        container.appendChild((Node)child.getHtmlOuterElement());
    }

    protected String null2Empty(String str) {
        if (str == null) {
            str = "";
        }
        return str;
    }

    protected Document loadFromResource(String name) {
        InputStream stream = this.getClass().getResourceAsStream(name);
        try {
            Document doc = Jsoup.parse((InputStream)stream, (String)"utf-8", (String)"");
            return doc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ViewAction processEvent(WebEvent event, ListValueMap<String, Object> parameters) {
        return this.processEvent(event, parameters.toSingleValueMap());
    }

    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void writeFile(HttpServletRequest req, HttpServletResponse response, String shortName) throws IOException {
        throw new RuntimeException("not supported");
    }

    protected void writeFile(HttpServletResponse response, File file) throws IOException {
        if (file == null) {
            return;
        }
        response.setContentType(file.getContentType());
        response.setContentLength((int)file.getSize());
        String headerKey = "Content-Disposition";
        String headerValue = String.format("attachment; filename=\"%s\"", file.getName());
        response.setHeader(headerKey, headerValue);
        ServletOutputStream outStream = response.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        InputStream inStream = file.getInputStream();
        while ((bytesRead = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        inStream.close();
        outStream.close();
    }

    @Override
    public WebComponent getParentWebComponent() {
        return (WebComponent)this.getParent();
    }

    @Override
    public List<WebComponent> getChildrenWebComponents() {
        ArrayList<WebComponent> webComponentList = new ArrayList<WebComponent>();
        for (TreeNode node : this.getChildren()) {
            webComponentList.add((WebComponent)node);
        }
        return webComponentList;
    }

    @Override
    public void replaceChild(WebComponent oldChild, WebComponent newChild) {
        int index = this.getChildren().indexOf(oldChild);
        this.getChildren().set(index, (TreeNode)newChild);
    }

    protected CSSAttributes createCommonStyles() {
        Border[] borders;
        Length height;
        Length width;
        Color backgroundColor;
        Color color;
        TextDecoration textDecoration;
        Font font;
        Component comp = this.getComponent();
        CSSAttributes attrs = new CSSAttributes();
        if (!comp.isVisible()) {
            attrs.add(new CSSAttribute("display", "none"));
        }
        if ((font = comp.getFont()) != null) {
            if (font.getWeight() == FontWeight.BOLD) {
                attrs.add(new CSSAttribute("font-weight", "bold"));
            }
            if (font.getSize() != null) {
                attrs.add(new CSSAttribute("font-size", font.getSize()));
            }
        }
        if ((textDecoration = comp.getTextDecoration()) != null) {
            attrs.add(new CSSAttribute("text-decoration", textDecoration.getCssValue()));
        }
        if ((color = comp.getColor()) != null) {
            attrs.add(new CSSAttribute("color", "#" + color.getAsHex()));
        }
        if ((backgroundColor = comp.getBackgroundColor()) != null) {
            attrs.add(new CSSAttribute("background-color", "#" + backgroundColor.getAsHex()));
        }
        if ((width = comp.getWidth()) != null) {
            attrs.add(new CSSAttribute("max-width", width.getCssExpr()));
        }
        if ((height = comp.getHeight()) != null) {
            attrs.add(new CSSAttribute("max-height", height.getCssExpr()));
        }
        if ((borders = comp.getBorders()) != null) {
            if (borders.length != 4) {
                throw new RuntimeException("length of borders must be 4 if not null");
            }
            attrs.add(this.createBorderAttribute(Direction.LEFT, borders[0]));
            attrs.add(this.createBorderAttribute(Direction.TOP, borders[1]));
            attrs.add(this.createBorderAttribute(Direction.RIGHT, borders[2]));
            attrs.add(this.createBorderAttribute(Direction.BOTTOM, borders[3]));
        } else {
            Border border = comp.getBorder();
            if (border != null) {
                attrs.add(this.createBorderAttribute(null, border));
            }
        }
        int[] margins = comp.getMargins();
        if (margins != null) {
            if (margins.length != 4) {
                throw new RuntimeException("length of margins must be 4 if not null");
            }
            attrs.add(this.createMarginAttribute(Direction.LEFT, margins[0]));
            attrs.add(this.createMarginAttribute(Direction.TOP, margins[1]));
            attrs.add(this.createMarginAttribute(Direction.RIGHT, margins[2]));
            attrs.add(this.createMarginAttribute(Direction.BOTTOM, margins[3]));
        } else {
            Border border = comp.getBorder();
            if (border != null) {
                attrs.add(this.createBorderAttribute(null, border));
            }
        }
        return attrs;
    }

    private CSSAttribute createBorderAttribute(Direction direction, Border border) {
        String value = String.format("%dpx %s #%s", border.getWidth(), border.getStyle().name().toLowerCase(), border.getColor().getAsHex());
        String name = direction == null ? "border" : "border-" + direction.name().toLowerCase();
        CSSAttribute attr = new CSSAttribute(name, value);
        return attr;
    }

    private CSSAttribute createMarginAttribute(Direction direction, int size) {
        String value = String.format("%dpx", size);
        String name = direction == null ? "margin" : "margin-" + direction.name().toLowerCase();
        CSSAttribute attr = new CSSAttribute(name, value);
        return attr;
    }

    protected void applyStyle(Element element, CSSAttributes attrs) {
        if (!attrs.isEmpty()) {
            element.attr("style", attrs.toCssText());
        }
    }

    protected void applyEvents(Element element, String inputName, String event) {
        Component comp = this.getComponent();
        if (comp.containsListener("click")) {
            String onclick = String.format("_plum_post('%s','%s','%s')", this.getId(), inputName, event);
            element.attr("onclick", onclick);
        }
    }

    public String calcHash() {
        return DigestUtils.md5Hex((String)(this.getId() + this.htmlOuterElement.outerHtml()));
    }

    public String calcHashOfChildrenId() {
        StringBuilder sb = new StringBuilder();
        for (TreeNode node : this.getChildren()) {
            AbstractWebComponent awc = (AbstractWebComponent)node;
            sb.append(awc.getId());
        }
        return DigestUtils.md5Hex((String)sb.toString());
    }

    @Override
    public String getOwnHash() {
        return this.ownHash;
    }

    @Override
    public void setOwnHash(String ownHash) {
        this.ownHash = ownHash;
    }

    @Override
    public String getChildrenIdsHash() {
        return this.childrenIdsHash;
    }

    @Override
    public void setChildrenIdsHash(String childrenIdsHash) {
        this.childrenIdsHash = childrenIdsHash;
    }

    public boolean isStaticResource() {
        return this.staticResource;
    }

    public void setStaticResource(boolean staticResource) {
        this.staticResource = staticResource;
    }
}

