/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component;

import java.util.Map;
import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public abstract class AbstractTemplateWebComponent
extends AbstractWebComponent {
    protected Element themeTemplate;

    public AbstractTemplateWebComponent(String id, Component component, Element themeTemplate) {
        super(id, component);
        this.themeTemplate = themeTemplate;
    }

    public abstract Element getComponentHtmlTemplate();

    public abstract void setComponentHtmlTemplate(Element var1);

    public abstract String getComponentType();

    public Element getComponentHtmlTemplate(boolean createIfNotExists) {
        if (this.getComponentHtmlTemplate() == null && createIfNotExists) {
            ComponentElements componentTemplate = this.findAndCloneElement(this.themeTemplate, false);
            this.setComponentHtmlTemplate(componentTemplate.getOuter());
        }
        return this.getComponentHtmlTemplate();
    }

    protected ComponentElements findAndCloneElement(Element template, boolean emptyInnerHtml) {
        String outerClass = this.getOuterClass();
        Element outer = null;
        Element inner = null;
        Elements elements = template.getElementsByClass(outerClass);
        if (elements == null || elements.isEmpty()) {
            throw new RuntimeException("unable to find by class: " + outerClass);
        }
        outer = elements.first().clone();
        Elements inners = outer.getElementsByClass(this.getInnerClass());
        if (inners != null) {
            inner = inners.first();
        }
        ComponentElements componentElements = new ComponentElements(outer, inner);
        if (inner != null && emptyInnerHtml) {
            inner.empty();
        }
        return componentElements;
    }

    protected String getOuterClass() {
        return this.getElementClass("outer");
    }

    protected String getInnerClass() {
        return this.getElementClass("inner");
    }

    protected String getElementClass(String shortName) {
        return this.getComponentType() + "-" + shortName;
    }

    protected Element findElementByClass(Element element, String shortName) {
        String className = this.getElementClass(shortName);
        Elements elements = element.getElementsByClass(className);
        if (elements != null) {
            return elements.first();
        }
        return null;
    }

    protected Element findElementByClass(String shortName) {
        return this.findElementByClass(this.htmlOuterElement, shortName);
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
    }

    protected File getParameterAsFile(Map<String, Object> parameters, String name) {
        Object value = parameters.get(name);
        if (value instanceof File) {
            return (File)value;
        }
        return null;
    }
}

