/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web;

import java.util.HashMap;
import java.util.Map;
import net.abstractfactory.plum.view.client.ViewSyncMode;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.input.WebCheckBox;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class WebPageView {
    static final String START_JS = "_plum_start_js";
    private Map<String, WebComponent> webComponentMap = new HashMap<String, WebComponent>();
    private Map<String, WebCheckBox> webCheckBoxMap = new HashMap<String, WebCheckBox>();
    private Map<Component, WebComponent> componentToWebComponentMap = new HashMap<Component, WebComponent>();
    private Map<String, String> nodeHashes = new HashMap<String, String>();
    private WebComponent rootContentWebComponent;
    private Document doc;
    private String sessionId;
    Element head;
    Element body;
    Element form;
    Element startJs;
    String activeElementId;
    private String version;
    private ViewSyncMode viewSyncMode;

    public WebPageView(Document document, String pushTopic, ViewSyncMode viewSyncMode) {
        this.doc = document;
        this.sessionId = this.sessionId;
        this.viewSyncMode = viewSyncMode;
        this.head = this.doc.getElementsByTag("head").get(0);
        this.body = this.doc.getElementsByTag("body").get(0);
        this.form = this.body.getElementsByTag("form").get(0);
        this.startJs = this.body.getElementById(START_JS);
        for (Element e : this.body.children()) {
            if (e.tagName().equalsIgnoreCase("script") || e.attr("keep").equals("true")) continue;
            e.remove();
        }
        String jsData = this.startJs.data().replaceAll("#topic#", pushTopic).replaceAll("#viewSyncMode#", viewSyncMode.name());
        this.startJs.empty();
        this.startJs.appendChild((Node)new DataNode(jsData, ""));
    }

    public Map<String, WebComponent> getWebComponentMap() {
        return this.webComponentMap;
    }

    public Map<String, WebCheckBox> getWebCheckBoxMap() {
        return this.webCheckBoxMap;
    }

    public Map<Component, WebComponent> getComponentToWebComponentMap() {
        return this.componentToWebComponentMap;
    }

    public Map<String, String> getNodeHashes() {
        return this.nodeHashes;
    }

    public void setRootContentWebComponent(WebComponent rootContentWebComponent, String title) {
        this.rootContentWebComponent = rootContentWebComponent;
        if (title != null) {
            this.doc.title(title);
        }
        this.body.prependChild((Node)this.form);
        this.form.prependChild((Node)rootContentWebComponent.getHtmlOuterElement());
    }

    public WebComponent getRootContentWebComponent() {
        return this.rootContentWebComponent;
    }

    public Document getDoc() {
        return this.doc;
    }

    public String getActiveElementId() {
        return this.activeElementId;
    }

    public void setActiveElementId(String activeElementId) {
        this.activeElementId = activeElementId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.form.getElementById("_plum_view_version").val(version);
    }
}

