/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.abstractfactory.common.ListValueMap;
import net.abstractfactory.plum.view.web.InputTagName;
import org.apache.log4j.Logger;

public class PlumForm {
    private Logger logger = Logger.getLogger(this.getClass());
    public static final String SPECIAL_PARAMETER_PREFIX = "_plum_";
    static final String COMPONENT = "_plum_component";
    static final String TAG = "_plum_tag";
    static final String EVENT = "_plum_event";
    public static final String EVENT_PARAMETER = "_plum_event_parameter";
    public static final String VIEW_VERSION = "_plum_view_version";
    public static final String ACTIVE_COMPONENT = "_plum_active_component";
    static Set<String> specialParameterNames = new HashSet<String>();
    private Map<String, String> specialParameters = new HashMap<String, String>();
    private Map<String, ListValueMap<String, Object>> componentParameters;

    public PlumForm(ListValueMap<String, Object> parameterMap) {
        this.processComponentInputs(parameterMap);
    }

    private void processComponentInputs(ListValueMap<String, Object> parameterMap) {
        this.componentParameters = new HashMap<String, ListValueMap<String, Object>>();
        for (String name : parameterMap.keySet()) {
            List value = parameterMap.get((Object)name);
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (Object obj : value) {
                    sb.append(obj.toString() + ",");
                }
                this.logger.debug((Object)(name + "=" + sb.toString()));
            }
            if (name.startsWith(SPECIAL_PARAMETER_PREFIX)) {
                if (!specialParameterNames.contains(name)) continue;
                this.specialParameters.put(name, (String)value.get(0));
                continue;
            }
            InputTagName inputTagName = InputTagName.valueOf(name);
            if (inputTagName == null) {
                throw new RuntimeException("invalid input tag name:" + name);
            }
            String componentId = inputTagName.getComponentId();
            String tagName = inputTagName.getWebTagName();
            ListValueMap parameters = this.componentParameters.get(componentId);
            if (parameters == null) {
                parameters = new ListValueMap();
                this.componentParameters.put(componentId, (ListValueMap<String, Object>)parameters);
            }
            parameters.put((Object)tagName, value);
        }
    }

    public Map<String, String> getSpecialParameters() {
        return this.specialParameters;
    }

    public Map<String, ListValueMap<String, Object>> getComponentParameters() {
        return this.componentParameters;
    }

    public String getComponentId() {
        return this.specialParameters.get(COMPONENT);
    }

    public String getTag() {
        return this.specialParameters.get(TAG);
    }

    public String getEvent() {
        return this.specialParameters.get(EVENT);
    }

    public String getEventParameter() {
        return this.specialParameters.get(EVENT_PARAMETER);
    }

    public String getViewVersion() {
        return this.specialParameters.get(VIEW_VERSION);
    }

    public String getActiveComponentId() {
        return this.specialParameters.get(ACTIVE_COMPONENT);
    }

    static {
        specialParameterNames.add(COMPONENT);
        specialParameterNames.add(TAG);
        specialParameterNames.add(EVENT);
        specialParameterNames.add(EVENT_PARAMETER);
        specialParameterNames.add(VIEW_VERSION);
        specialParameterNames.add(ACTIVE_COMPONENT);
    }
}

