package net.abstractfactory.plum.view.web.layout;

import java.util.List;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.layout.GridLayout;
import net.abstractfactory.plum.view.layout.HorizontalBox;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;

import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

/**
 * a table impelmentation.
 * 
 * @author jack
 *
 */
public class WebTableHBox extends AbstractWebComponent {

	Element table;
	Element body;
	Element currentTR;

	List<Element> trList;

	public WebTableHBox(String id, Component component) {
		super(id, component);
	}

	private HorizontalBox getHBox() {
		return (HorizontalBox) component;
	}

	@Override
	public void createHtmlElement() {

		table = new Element(Tag.valueOf("table"), "");
		table.attr("class", "hbox");

		currentTR = new Element(Tag.valueOf("tr"), "");
		table.appendChild(currentTR);

		htmlOuterElement = table;
	}

	@Override
	protected Element getHtmlInnerElementForNewChild() {

		Element cell = new Element(Tag.valueOf("td"), "");
		currentTR.appendChild(cell);

		return cell;
	}

}
