package net.abstractfactory.plum.view.web.component.web;

import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.web.HtmlView;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;

public class WebHtmlView extends AbstractWebComponent {
	public WebHtmlView(String id, Component component) {
		super(id, component);
	}

	protected HtmlView getHtmlView() {
		return (HtmlView) component;
	}

	public void createHtmlElement() {

		Element div = new Element(Tag.valueOf("div"), "");
		div.attr("class", "html");

		htmlOuterElement = div;
		htmlInnerElement = div;
		
		div.append(getHtmlView().getContent());

		if (!getHtmlView().isVisible())
			htmlOuterElement.addClass("hide");
	}

}
