package net.abstractfactory.plum.view.web.component.tree;

import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.tab.Tab;
import net.abstractfactory.plum.view.component.tab.Tabs;
import net.abstractfactory.plum.view.component.tree.TreeView;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

/**
 * 
 * @author jack
 *
 */
public class WebTreeView extends AbstractTemplateWebComponent {
	static Logger logger = Logger.getLogger(WebTreeView.class);

	//private static final String PARAMETER_INDEX = "index";

	private static Element componentHtmlTemplate;

	


	public WebTreeView(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	public TreeView getTreeView() {
		return (TreeView) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();


	}

	protected ViewAction onNodeSelected(final int newIndex) {

		return new AbstractViewAction(WebEvent.CLICK.name()) {

			@Override
			public void execute(Component view) {

				Tabs tabs = (Tabs) view;
				tabs.setActiveTab(newIndex, true);

			}
		};

	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.CLICK) {
			/*
			String strIndex = (String) parameters.get(PARAMETER_INDEX);
			Integer index = Integer.valueOf(strIndex);
			return onTabChange(index);
			*/
			return null;

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "tree";
	}
}
