package net.abstractfactory.plum.view.web.component.menu;

import java.util.Map;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.menu.MenuItem;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

/**
 * either menu item or contains sub-menu-item
 * 
 * @author jack
 * 
 */
public class WebMenuItem extends AbstractTemplateWebComponent {

	static final String COMPONENT_TYPE = "menuitem";

	private static final String LINK = "link";

	private static Element componentHtmlTemplate;

	private Element link;

	public WebMenuItem(String id, Component component,
			Element templateTemplate) {
		super(id, component, templateTemplate);
	}

	protected MenuItem getMenuItem() {
		return (MenuItem) component;
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		// find the link
		link = htmlOuterElement.getElementsByTag("a").first();
		link.attr("href", "javascript:{}");

		String onclick = String.format("_plum_post('%s','%s','click')", getId(),
				LINK);
		link.attr("onclick", onclick);

		link.appendText(getComponent().getCaption());
	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {

		if (event == WebEvent.CLICK) {

			return new AbstractViewAction(event.name()) {

				@Override
				public void execute(Component view) {
					MenuItem item = (MenuItem) view;
					item.click();

				}
			};
		} else
			throw new RuntimeException("unknow event:" + event);
	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		this.componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return COMPONENT_TYPE;
	}
}
