package net.abstractfactory.plum.view.web.component.menu;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.web.WebTemplatePage;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class WebMenuBar extends AbstractTemplateWebComponent {
	
	static final String COMPONENT_TYPE="menubar";

	private static Element componentHtmlTemplate;

	public WebMenuBar(String id, Component component, Element themeTemplate) {
		super(id, component, themeTemplate);
	}

	protected Window getWindow() {
		return (Window) component;
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

	}

	@Override
	public Element getComponentHtmlTemplate() {
		
		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		this.componentHtmlTemplate = element;
		
	}

	@Override
	public String getComponentType() {

		return COMPONENT_TYPE;
	}

}
