package net.abstractfactory.plum.view.web.component.menu;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

/**
 * sub-menu.
 * 
 * @author jack
 * 
 */
public class WebMenu extends AbstractTemplateWebComponent {
	static final String COMPONENT_TYPE = "menu";

	private static Element componentHtmlTemplate;

	private Element link;
	private Element text;

	public WebMenu(String id, Component component, Element themeTemplate) {
		super(id, component, themeTemplate);
	}

	protected Window getWindow() {
		return (Window) component;
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		link =htmlOuterElement.getElementsByTag("a").first();
		link.attr("href","");
		
		text = htmlOuterElement.getElementsByClass("menu-text").first();
		text.text(null2Empty(getComponent().getCaption()));

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element componentHtmlTemplate) {

		WebMenu.componentHtmlTemplate = componentHtmlTemplate;
	}

	@Override
	public String getComponentType() {

		return COMPONENT_TYPE;
	}

}
