package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jsoup.nodes.Element;

import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.input.value.UrlFile;
import net.abstractfactory.plum.input.value.video.Video;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.VideoBox;
import net.abstractfactory.plum.view.component.audiobox.AudioBox;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import net.abstractfactory.plum.view.web.component.MultipartFileSender;

public class WebVideoBox extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private final String INPUT_NAME = "video";
	private Element video;
	private Element source;

	public WebVideoBox(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private VideoBox getVideobox() {
		return (VideoBox) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(getComponentHtmlTemplate(true), false);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();
		source = htmlInnerElement.getElementsByClass("video-source").first();
		source.remove();

		htmlInnerElement.empty();

		video = htmlOuterElement;

		VideoBox videoBox = getVideobox();

		if (videoBox.isShowControls()) {
			video.attr("controls", "controls");
		} else {
			video.removeAttr("controls");
		}

		if (videoBox.isAutoPlay()) {
			video.attr("autoplay", "autoplay");
		}

		if (videoBox.isMuted()) {
			video.attr("muted", "muted");
		}

		if (videoBox.isLoop()) {
			video.attr("loop", "loop");
		}

		source.attr("src", WebFileUtils.generateUrl(getId(), "video", videoBox.getDataVersionAsString()));
		source.attr("type", videoBox.getData().getFile().getContentType());

		htmlInnerElement.appendChild(source);

		htmlInnerElement.appendText("Your browser not support video element");

	}

	@Override
	public void writeFile(HttpServletRequest req, HttpServletResponse response, String shortName) throws IOException {
		Video video = getVideobox().getData();
		if (video != null) {
			File fileValue = video.getFile();

			if (fileValue instanceof UrlFile) {
				UrlFile urlFile = (UrlFile) fileValue;

				if (urlFile.getUrl().getProtocol().equalsIgnoreCase("file")) {
					try {
						String filePath = urlFile.getUrl().toURI().toString();
						System.out.println("file path:" + filePath);
						MultipartFileSender.fromURIString(filePath).with(req).with(response).serveResource();
					} catch (Exception e) {
						throw new RuntimeException(e);

					}
				} else {
					writeFile(response, video.getFile());
				}
			} else {
				writeFile(response, video.getFile());
			}
		}
	}

	protected ViewAction onValueChange(String newValue) {

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				AudioBox box = (AudioBox) view;
				// do what?
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			String newValue = (String) parameters.get(INPUT_NAME);
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "videobox";
	}
}
