package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;

import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.TextBox;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;

public class WebTextBox extends AbstractWebComponent {
	public static final String VALUE_CHANGE = "valueChange";
	private final String INPUT_NAME = "text";
	public static final String PARAMETER_KEY_CODE = "keyCode";

	private Element text;

	public WebTextBox(String id, Component component) {
		super(id, component);
	}

	protected TextBox getTextBox() {
		return (TextBox) component;
	}

	public void createHtmlElement() {
		TextBox textBox = getTextBox();

		text = new Element(Tag.valueOf("input"), "");

		if (textBox.isMasked()) {
			text.attr("type", "password");
		} else {
			text.attr("type", "text");
		}

		if (textBox.getText() != null)
			text.attr("value", textBox.getText());

		text.attr("name", getFullInputName(INPUT_NAME));

		htmlOuterElement = text;
		htmlInnerElement = htmlOuterElement;

		// text.attr("onKeyDown", "return false;");
		// text.attr("onKeyUp", "return false;");

		if (textBox.containsListener(Component.EVENT_KEY_PRESS)) {
			String onKeyPress;
			if (textBox.getPressKeys() == null) {
				onKeyPress = String.format("return submitWhenKeyPress(event, '%s','%s','%s','%s'); ", getId(), "input",
						WebEvent.KEY_PRESS.name(), PARAMETER_KEY_CODE);
			} else {

				StringBuilder sb = new StringBuilder();
				int count = 0;
				for (Integer num : textBox.getPressKeys()) {
					if (count > 0) {
						sb.append(",");
					}

					sb.append(num);

					count++;
				}
				String keysStr = sb.toString();

				onKeyPress = String.format("return submitWhenKeyPress(event, '%s','%s','%s','%s',[%s]); ", getId(),
						"input", WebEvent.KEY_PRESS.name(), PARAMETER_KEY_CODE, keysStr);

			}
			text.attr("onKeyUp", onKeyPress);

		} else {
			text.attr("onKeyUp", "return preventSubmitForm(event);");
		}
	}

	protected ViewAction onValueChange(String newValue) {
		text.attr("value", newValue);

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				TextBox tb = (TextBox) view;
				tb.setText(text.attr("value"), true);
			}
		};
	}

	protected ViewAction onKeyPress(final long keyCode) {

		return new AbstractViewAction(WebEvent.KEY_PRESS.name()) {
			@Override
			public void execute(Component view) {
				TextBox tb = (TextBox) view;
				tb.notifyEventListeners(Component.EVENT_KEY_PRESS, keyCode);
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			String newValue = (String) parameters.get(INPUT_NAME);
			return onValueChange(newValue);

		}
		if (event == WebEvent.KEY_PRESS) {
			String keyCodeStr = (String) parameters.get(PARAMETER_KEY_CODE);
			long keyCode = Long.valueOf(keyCodeStr);
			return onKeyPress(keyCode);

		} else
			throw new RuntimeException("unknow event:" + event);

	}
}
