package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.TextArea;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;

import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class WebTextArea extends AbstractWebComponent {
	public static final String VALUE_CHANGE = "valueChange";
	private final String INPUT_NAME = "text";
	private Element textarea;

	public WebTextArea(String id, Component component) {
		super(id, component);
	}

	protected TextArea getTextArea() {
		return (TextArea) component;
	}

	public void createHtmlElement() {

		textarea = new Element(Tag.valueOf("textarea"), "");
		
		if (getTextArea().getText() != null)
			textarea.appendText(getTextArea().getText());

		textarea.attr("name", getFullInputName(INPUT_NAME));

		htmlOuterElement = textarea;
		htmlInnerElement = htmlOuterElement;
	}

	protected ViewAction onValueChange(String newValue) {
		textarea.text(newValue);

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				TextArea tb = (TextArea) view;
				tb.setText(textarea.text(), true);
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			String newValue = (String) parameters.get(INPUT_NAME);
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}
}
