package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.SpinBox;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.jsoup.nodes.Element;

public class WebSpinBox extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private final String INPUT_NAME = "text";
	private Element text;

	public WebSpinBox(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private SpinBox getSpinbox() {
		return (SpinBox) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		text = htmlInnerElement;

		text.attr("name", getFullInputName(INPUT_NAME));

		text.attr("minimum", String.valueOf(getSpinbox().getMin().toString()));
		text.attr("maximum", String.valueOf(getSpinbox().getMax()));
		text.attr("step", String.valueOf(getSpinbox().getStep()));
		text.attr("value", String.valueOf(getSpinbox().getValue()));
	}

	protected ViewAction onValueChange(String newValue) {
		text.attr("value", newValue);

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				SpinBox tb = (SpinBox) view;
				tb.setValue(Integer.valueOf(text.attr("value")), true);
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			String newValue = (String) parameters.get(INPUT_NAME);
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "spinbox";
	}
}
