package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jsoup.nodes.Element;

import net.abstractfactory.plum.input.value.image.Image;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.RadioBox;
import net.abstractfactory.plum.view.component.RadioItem;
import net.abstractfactory.plum.view.component.ViewOption;
import net.abstractfactory.plum.view.component.listbox.Options;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

public class WebRadioItem extends AbstractTemplateWebComponent {

	public static final String VALUE_CHANGE = "valueChange";
	private static final String INPUT = "input";

	private static Element componentHtmlTemplate;

	private Element inputElement;

	public WebRadioItem(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private RadioItem getRadioItem() {
		return (RadioItem) getComponent();
	}

	public void createHtmlElement() {

		RadioItem radioItem = getRadioItem();
		RadioBox radioBox = radioItem.getRadioBox();

		ComponentElements componentElements = findAndCloneElement(getComponentHtmlTemplate(true), false);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		inputElement = findElementByClass(INPUT);

		inputElement.attr("name", getFullInputName(radioBox.getId(), INPUT));

		int index = radioBox.indexOf(radioItem);
		inputElement.attr("value", String.valueOf(index));

		htmlInnerElement.empty();

	}

	protected ViewAction onValueChange(final Object newValue) {

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				// getRadioBox().setValue(newValue);
				RadioItem radioItem = (RadioItem) view;

				RadioBox radioBox = radioItem.getRadioBox();

				radioBox.setSelectedItem(radioItem);
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			Object newValue = (Object) parameters.get(INPUT);
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "radioitem";
	}
}
