package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.helpers.OptionConverter;
import org.jsoup.nodes.Element;

import net.abstractfactory.plum.input.value.image.Image;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.RadioBox;
import net.abstractfactory.plum.view.component.ViewOption;
import net.abstractfactory.plum.view.component.listbox.Options;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

public class WebRadioBox extends AbstractTemplateWebComponent {

	public static final String VALUE_CHANGE = "valueChange";
	private static final String INPUT = "input";
	private static Element componentHtmlTemplate;

	private List<ViewOption> options;

	private int selectedIndex = -1;

	public WebRadioBox(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private RadioBox getRadioBox() {
		return (RadioBox) getComponent();
	}

	public void createHtmlElement() {
		// ===create local state
		RadioBox radioBox = getRadioBox();

		createViewOptions(radioBox);

		selectedIndex = radioBox.getSelectedIndex();

		ComponentElements componentElements = findAndCloneElement(getComponentHtmlTemplate(true), false);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		htmlInnerElement.empty();

	}

	private void createViewOptions(RadioBox radioField) {
		options = new ArrayList<ViewOption>();

		Options inputOptions = radioField.getOptions();

		// create options
		for (int i = 0; i < inputOptions.size(); i++) {

			Object obj = inputOptions.get(i);

			String str = obj == null ? "" : obj.toString();

			String value = str;
			String text = str;
			Image image = null;

			ViewOption option = new ViewOption(value, text, image);

			options.add(option);
		}
	}

	protected ViewAction onValueChange(final Integer newValue) {

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {

				setSelectedIndex(newValue);

				RadioBox radioBox = (RadioBox) view;
				radioBox.setSelectedIndex(selectedIndex);
			}
		};
	}

	public int getSelectedIndex() {
		return selectedIndex;
	}

	public void setSelectedIndex(int selectedIndex) {
		this.selectedIndex = selectedIndex;
	}

	@Override
	public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			String newValueStr = (String) parameters.get(INPUT);
			Integer newValue = Integer.valueOf(newValueStr);
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "radiobox";
	}
}
