package net.abstractfactory.plum.view.web.component.input;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.helpers.OptionConverter;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

import net.abstractfactory.common.ListValueMap;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.ListBox;
import net.abstractfactory.plum.view.component.ViewOption;
import net.abstractfactory.plum.view.component.listbox.Options;
import net.abstractfactory.plum.view.component.listbox.SelectionMode;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;

public class WebListBox extends AbstractWebComponent {
	public static final String VALUE_CHANGE = "valueChange";
	private final String INPUT_NAME = "select";
	private Element select;

	private List<ViewOption> optionList;

	private Set<Integer> selectedIndices = new HashSet<Integer>();

	public WebListBox(String id, Component component) {
		super(id, component);

	}

	protected ListBox getListBox() {
		return (ListBox) component;
	}

	public void createHtmlElement() {
		// ===create local state
		ListBox listBox = getListBox();

		optionList = new ArrayList<ViewOption>();

		Options inputOptions = listBox.getOptions();
		
		// create options
		for (int i = 0; i < inputOptions.size(); i++) {

			Object obj = inputOptions.get(i);

			String str = obj==null? "":obj.toString();
			
			String value = str;
			String text = str;

			ViewOption option = new ViewOption(value, text);
			optionList.add(option);
		}

		selectedIndices.addAll(listBox.getSelectedIndices());

		// ==========create html=========

		select = new Element(Tag.valueOf("select"), "");
		if (listBox.getSelectionMode() == SelectionMode.MULTIPLE)
			select.attr("multiple", "");

		select.attr("id", id);
		select.attr("name", getFullInputName(INPUT_NAME));

		select.attr("size", "4");

		createOptionElements(select);

		if (getListBox().containsListener(Component.EVENT_VALUE_CHANGE)) {

			String onChange = String.format("_plum_post('%s','%s','%s')",
					getId(), INPUT_NAME, WebEvent.VALUE_SET.name());
			select.attr("onChange", onChange);
		}

		htmlOuterElement = select;
		htmlInnerElement = null;
	}

	private boolean isSelected(int index) {
		for (int i : selectedIndices) {
			if (i == index)
				return true;
		}
		return false;
	}

	private void createOptionElements(Element select) {

		for (int i = 0; i < optionList.size(); i++) {
			ViewOption option = optionList.get(i);

			Element optionElement = new Element(Tag.valueOf("option"), "");
			optionElement.attr("value", option.getValue());
			optionElement.appendText(option.getText());

			if (isSelected(i))
				optionElement.attr("selected", "selected");

			select.appendChild(optionElement);
		}

	}

	protected ViewAction onValueChange(List<Object> newValue) {
		selectedIndices.clear();
		// find the selected index

		for (int j = 0; j < newValue.size(); j++) {
			String newVal = (String) newValue.get(j);
			for (int i = 0; i < optionList.size(); i++) {
				ViewOption si = optionList.get(i);

				if (si.getValue().equals(newVal)) {
					selectedIndices.add(i);

				}
			}
		}

		// update the selected index
		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				ListBox listBox = (ListBox) view;
				listBox.setSelectedIndices(selectedIndices, true);
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event,
			ListValueMap<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			List<Object> newValue = parameters.get(INPUT_NAME);

			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}
}
