package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.abstractfactory.plum.input.value.image.Image;
import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.ImageButton;
import net.abstractfactory.plum.view.component.attribute.Length;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.CSSAttribute;
import net.abstractfactory.plum.view.web.CSSAttributes;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.jsoup.nodes.Element;

public class WebImageButton extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private final String BUTTON = "button";
	private final String IMAGE = "image";
	Element buttonElement;
	Element imageElement;

	public WebImageButton(String id, Component component,
			Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private ImageButton getImageButton() {
		return (ImageButton) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), false);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		buttonElement = htmlOuterElement;
		imageElement = findElementByClass(IMAGE);

		// buttonElement.appendText(caption);

		applyEvents(buttonElement, BUTTON, Button.EVENT_CLICK);

		imageElement.attr("id", id);
		// imageElement.attr("version",
		// String.valueOf(imageField.getImageVersion()));
		imageElement.attr("src", WebFileUtils.generateUrl(getId(), "image"));

		// width and height apply on image element
		applyStyle(imageElement, createImageStyles());

		buttonElement.attr("name", getFullInputName(BUTTON));
	}

	@Override
	protected CSSAttributes createCommonStyles() {
		CSSAttributes attrs = super.createCommonStyles();
		attrs.remove("width");
		attrs.remove("height");

		return attrs;
	}

	private CSSAttributes createImageStyles() {
		Component comp = getComponent();

		CSSAttributes attrs = new CSSAttributes();

		Length width = comp.getWidth();
		if (width != null) {
			attrs.add(new CSSAttribute("width", width.getCssExpr()));
		}

		Length height = comp.getHeight();
		if (height != null) {
			attrs.add(new CSSAttribute("height", height.getCssExpr()));
		}

		return attrs;
	}

	@Override
	public void writeFile(HttpServletRequest req, HttpServletResponse response,
			String shortName) throws IOException {
		Image image = getImageButton().getImage();
		if (image != null)
			writeFile(response, image.getFile());

	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.CLICK) {

			return new AbstractViewAction(event.name()) {

				@Override
				public void execute(Component view) {
					Button btn = (Button) view;
					btn.click();

				}
			};

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "imageButton";
	}
}
