package net.abstractfactory.plum.view.web.component.input;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jsoup.nodes.Element;

import net.abstractfactory.common.ImageUtils;
import net.abstractfactory.common.OgnlLocator;
import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.input.value.MemoryFile;
import net.abstractfactory.plum.input.value.image.Image;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.ImageBox;
import net.abstractfactory.plum.view.component.attribute.Length;
import net.abstractfactory.plum.view.component.attribute.LengthUnit;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

public class WebImageBox extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private final String IMAGE = "image";
	Element imageElement;

	public WebImageBox(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private ImageBox getImageView() {
		return (ImageBox) getComponent();
	}

	@Override
	public void writeFile(HttpServletRequest req, HttpServletResponse response, String shortName) throws IOException {
		Image image = getImageView().getData();
		if (image == null) {
			return;
		}

		File file;

		String strWidth = req.getParameter("width");
		String strHeight = req.getParameter("height");
		if (strWidth != null && strHeight != null) {

			BufferedImage image2 = ImageIO.read(image.getFile().getInputStream());

			int width = Integer.parseInt(strWidth);
			int height = Integer.parseInt(strHeight);

			BufferedImage image3 = ImageUtils.scale(image2, width, height);

			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			ImageIO.write(image3, "jpg", baos);
			baos.flush();
			byte[] imageInByte = baos.toByteArray();
			baos.close();

			file = new MemoryFile(imageInByte);

		} else {

			file = image.getFile();
		}

		writeFile(response, file);

	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		imageElement = htmlOuterElement;

		ImageBox imageView = getImageView();

		imageElement.attr("id", id);
		imageElement.attr("version", imageView.getDataVersionAsString());
		imageElement.removeAttr("alt");

		imageView.getDataVersion();

		String url;
		if (imageView.getData() != null) {
			OgnlLocator locator = imageView.getData().getLocator();

			if (isStaticResource() && locator != null) {
				url = WebFileUtils.generateUrl(locator);
			} else {

				Length width = imageView.getWidth();
				Length height = imageView.getHeight();
				if (width != null && height != null && width.getUnit() == LengthUnit.PIXEL
						&& height.getUnit() == LengthUnit.PIXEL) {
					url = WebFileUtils.generateImageUrl(getId(), "image", imageView.getDataVersionAsString(),
							width.getSize(), height.getSize());
				} else {
					url = WebFileUtils.generateUrl(getId(), "image", imageView.getDataVersionAsString());
				}
			}
			imageElement.attr("src", url);
		}

	}

	protected ViewAction onValueChange(final Image newValue) {

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				getImageView().setData(newValue, true);
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			Image newValue = (Image) parameters.get(IMAGE);
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "image";
	}
}
