package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jsoup.nodes.Element;

import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.FilePicker;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

public class WebFilePicker extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private final String INPUT = "input";

	Element inputElement;


	public WebFilePicker(String id, Component component,
			Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private FilePicker getFilePicker() {
		return (FilePicker) getComponent();
	}

	@Override
	public void writeFile(HttpServletRequest req, HttpServletResponse response,
			String shortName) throws IOException {
		File file = getFilePicker().getValue();
		writeFile(response, file);
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), false);

		htmlOuterElement = componentElements.getOuter();
		// htmlInnerElement = componentElements.getInner();

		inputElement = findElementByClass(INPUT);
		inputElement.attr("id", id);
		inputElement.attr("name", getFullInputName(INPUT));

	}

	protected ViewAction onValueChange(final File newValue) {

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				getFilePicker().setValue(newValue, true);
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			File newValue = getParameterAsFile(parameters, INPUT);
			
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "filepicker";
	}
}
