package net.abstractfactory.plum.view.web.component.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.helpers.OptionConverter;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.ViewOption;
import net.abstractfactory.plum.view.component.listbox.DropdownList;
import net.abstractfactory.plum.view.component.listbox.Options;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;

public class WebDropdownList extends AbstractWebComponent {
	public static final String VALUE_CHANGE = "valueChange";
	private final String INPUT_NAME = "select";
	private Element select;

	private List<ViewOption> optionList;

	private int selectedIndex = -1;

	public WebDropdownList(String id, Component component) {
		super(id, component);

	}

	protected DropdownList getDropdownList() {
		return (DropdownList) component;
	}

	public void createHtmlElement() {
		// ===create local state
		DropdownList dlist = getDropdownList();

		optionList = new ArrayList<ViewOption>();

		Options inputOptions = dlist.getOptions();
		
		// create options
		for (int i = 0; i < inputOptions.size(); i++) {

			Object obj = inputOptions.get(i);

			String str = obj==null ? "":obj.toString();
			
			String value = str;
			String text = str;

			ViewOption option = new ViewOption(value, text);
			optionList.add(option);
		}

		selectedIndex = dlist.getSelectedIndex();

		// ==========create html=========

		select = new Element(Tag.valueOf("select"), "");
		select.attr("id", id);
		select.attr("name", getFullInputName(INPUT_NAME));

		createOptionElements(select);

		if (getDropdownList().containsListener(Component.EVENT_VALUE_CHANGE)) {

			String onChange = String.format("_plum_post('%s','%s','%s')", getId(), INPUT_NAME,
					WebEvent.VALUE_SET.name());
			select.attr("onChange", onChange);
		}

		htmlOuterElement = select;
		htmlInnerElement = null;
	}

	private void createOptionElements(Element select) {

		for (int i = 0; i < optionList.size(); i++) {
			ViewOption option = optionList.get(i);

			Element optionElement = new Element(Tag.valueOf("option"), "");
			optionElement.attr("value", option.getValue());
			optionElement.appendText(option.getText());

			if (i == selectedIndex)
				optionElement.attr("selected", "selected");

			select.appendChild(optionElement);
		}

	}

	protected ViewAction onValueChange(String newValue) {
		int oldSelectedIndex = this.selectedIndex;
		
		// find the selected index
		int newSelectedIndex = -1;
		for (int i = 0; i < optionList.size(); i++) {
			ViewOption si = optionList.get(i);

			if (si.getValue().equals(newValue)) {
				newSelectedIndex = i;
				break;
			}
		}
		
		final boolean stateChanged = (oldSelectedIndex != newSelectedIndex);

		if(stateChanged){
			this.selectedIndex = newSelectedIndex;
		}
		
		// update the selected index
		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				if (stateChanged) {
					DropdownList dropdownList = (DropdownList) view;
					dropdownList.setSelectedIndex(selectedIndex, true);
				}
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			String newValue = (String) parameters.get(INPUT_NAME);
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}
}
