package net.abstractfactory.plum.view.web.component.input;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import javax.management.RuntimeErrorException;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.DateTimePicker;
import net.abstractfactory.plum.view.component.DateTimePickerMode;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;
import org.omg.CORBA.ObjectHolder;

/**
 * css and js from http://tarruda.github.io/bootstrap-datetimepicker/
 * 
 * @author jack
 *
 */
public class WebDateTimePicker extends AbstractTemplateWebComponent {
	static Logger logger = Logger.getLogger(WebDateTimePicker.class);

	private static Element componentHtmlTemplate;

	private final String INPUT = "input";
	private Element text;
	private String format;
	private String webFormat;
	private DateTimePickerMode mode;

	public WebDateTimePicker(String id, Component component,
			Element templateTemplate) {
		super(id, component, templateTemplate);

		this.format = getDateTimePicker().getFormat();
		this.webFormat = toWebFormat(format);
		this.mode = getDateTimePicker().getMode();
	}

	private String toWebFormat(String format) {
		return format.replaceAll("y", "Y").replaceAll("d", "D");
	}

	public DateTimePicker getDateTimePicker() {
		return (DateTimePicker) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		text = findElementByClass(INPUT);
		text.attr("id", id);

		// bootstrap-datetimepicker has different format than java's.

		text.attr("date-format", webFormat);

		// set mode, default is true
		if (mode == DateTimePickerMode.DATE)
			text.attr("data-pick-time", "false");
		else if (mode == DateTimePickerMode.TIME)
			text.attr("data-pick-date", "false");

		text.attr("name", getFullInputName(INPUT));

		if (getDateTimePicker()
				.containsListener(Component.EVENT_VALUE_CHANGE)) {

			String onChange = String.format("_plum_post('%s','%s','%s')",
					getId(), INPUT, WebEvent.VALUE_SET.name());
			text.attr("onChange", onChange);
		}

		DateTimePicker dateTimePicker = getDateTimePicker();

		// set value
		String dateStr = dateTimePicker.getDateTimeString();
		if (dateStr == null)
			dateStr = "";

		text.attr("value", dateStr);

	}

	protected ViewAction onValueChange(String newValue) {

		text.attr("value", newValue);

		final net.abstractfactory.common.ObjectHolder<Date> dateTimeHolder = new net.abstractfactory.common.ObjectHolder<Date>();
		Date dateTime;
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		try {
			dateTime = sdf.parse(newValue);

		} catch (ParseException e) {
			// invalid string as date time.
			dateTime = null;
		}
		dateTimeHolder.setObject(dateTime);

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {

				DateTimePicker picker = (DateTimePicker) view;
				picker.setDatetime(dateTimeHolder.getObject(), true);

			}
		};

	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			String newValue = (String) parameters.get(INPUT);
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "DateTimePicker";
	}
}
