package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;

import net.abstractfactory.plum.view.component.CheckBox;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;

public class WebCheckBox extends AbstractTemplateWebComponent {
	static Logger logger = Logger.getLogger(WebCheckBox.class);

	private final String LABEL = "label";	
	private final String CHECKBOX = "input";
	
	private static Element componentHtmlTemplate;
	
	Element checkboxElement;
	Element spanElement;

	public WebCheckBox(String id, Component component,
			Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	public CheckBox getCheckBox() {
		return (CheckBox) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		checkboxElement = findElementByClass(CHECKBOX);
		checkboxElement.attr("id", id);
		//checkbox.attr("value", "foo");
		checkboxElement.attr("name", getFullInputName(CHECKBOX));

		if (getCheckBox().containsListener(Component.EVENT_VALUE_CHANGE)) {

			String onChange = String.format("_plum_post('%s','%s','%s')",
					getId(), CHECKBOX, WebEvent.VALUE_SET.name());
			checkboxElement.attr("onChange", onChange);
		}

		spanElement = findElementByClass(LABEL);

		CheckBox checkBox = getCheckBox();

		// set value
		if (checkBox.isChecked())
			checkboxElement.attr("checked", "checked");
		else
			checkboxElement.removeAttr("checked");

		// set label
		spanElement.empty();

		String caption = checkBox.getCaption();
		if (caption == null)
			caption = "";

		spanElement.appendText(caption);

	}

	public boolean isChecked() {
		return checkboxElement.hasAttr("checked");
	}

	protected ViewAction onValueChange(String newValue) {
		boolean oldState = isChecked();

		boolean newState = (newValue != null);

		final boolean stateChanged = (oldState != newState);
		if (stateChanged) {
			// update HTML tag state
			if (newState)
				checkboxElement.attr("checked", "checked");
			else
				checkboxElement.removeAttr("checked");

			if (logger.isDebugEnabled())
				logger.debug(String.format("component id (%s) state from %s to %s",getId(), oldState,
						newState));

		}

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				if (stateChanged) {
					CheckBox cb = (CheckBox) view;
					cb.setChecked(checkboxElement.hasAttr("checked"), true);
				}
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			String newValue =(String) parameters.get(CHECKBOX);
			return onValueChange(newValue);

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "checkbox";
	}
}
