package net.abstractfactory.plum.view.web.component.input;

import java.util.Map;

import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.nodes.Element;

public class WebButton extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private final String BUTTON = "button";
	Element buttonElement;

	public WebButton(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private Button getButton() {
		return (Button) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		buttonElement = htmlOuterElement;

		String caption = null2Empty(getComponent().getCaption());
		caption = StringEscapeUtils.escapeHtml4(caption);
		buttonElement.appendText(caption);

		applyEvents(buttonElement, BUTTON, Button.EVENT_CLICK);

		buttonElement.attr("name", getFullInputName(BUTTON));
	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.CLICK) {

			return new AbstractViewAction(event.name()) {

				@Override
				public void execute(Component view) {
					Button btn = (Button) view;
					btn.click();

				}
			};

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "button";
	}
}
