package net.abstractfactory.plum.view.web.component.input;

import java.io.IOException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.abstractfactory.plum.input.value.audio.Audio;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.audiobox.AudioBox;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.WebFileUtils;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.jsoup.nodes.Element;

public class WebAudioBox extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private final String INPUT_NAME = "audio";
	private Element audioElement;
	private Element source;

	public WebAudioBox(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private AudioBox getAudiobox() {
		return (AudioBox) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), false);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();
		source = htmlInnerElement.getElementsByClass("audio-source").first();
		source.remove();

		htmlInnerElement.empty();

		audioElement = htmlOuterElement;

		AudioBox audioBox = getAudiobox();

		if (audioBox.isShowControls()) {
			audioElement.attr("controls", "controls");
		} else {
			audioElement.removeAttr("controls");
		}

		if (audioBox.isAutoPlay()) {
			audioElement.attr("autoplay", "autoplay");
		}

		if (audioBox.isMuted()) {
			audioElement.attr("muted", "muted");
		}

		if (audioBox.isLoop()) {
			audioElement.attr("loop", "loop");
		}

		source.attr("src", WebFileUtils.generateUrl(getId(), "audio", audioBox.getDataVersionAsString()));

		Audio audio = audioBox.getData();
		if (audio != null) {
			source.attr("type", audioBox.getData().getFile().getContentType());
		}

		if (audioBox.containsListener(AudioBox.EVENT_ENDED)) {
			String onEnded = String.format("_plum_post('%s','%s','%s','');",
					getId(), "audio", WebEvent.ENDED.name());

			// onEnded = "alert('The audio has ended')";
			audioElement.attr("onEnded", onEnded);
		}

		htmlInnerElement.appendChild(source);

		htmlInnerElement.appendText("Your browser not support audio element");

	}

	@Override
	public void writeFile(HttpServletRequest req, HttpServletResponse response,
			String shortName) throws IOException {
		Audio audio = getAudiobox().getData();
		if (audio != null) {
			writeFile(response, audio.getFile());
		}
	}

	protected ViewAction onValueChange(String newValue) {

		return new AbstractViewAction(WebEvent.VALUE_SET.name()) {

			@Override
			public void execute(Component view) {
				AudioBox box = (AudioBox) view;
				// do what?
			}
		};
	}

	protected ViewAction onEnded() {

		return new AbstractViewAction(WebEvent.ENDED.name()) {

			@Override
			public void execute(Component view) {
				AudioBox box = (AudioBox) view;
				box.notifyEventListeners(AudioBox.EVENT_ENDED);
			}
		};
	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.VALUE_SET) {
			String newValue = (String) parameters.get(INPUT_NAME);
			return onValueChange(newValue);

		} else if (event == WebEvent.ENDED) {
			return onEnded();
		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "audiobox";
	}
}
