package net.abstractfactory.plum.view.web.component.container.window.dialog;

import net.abstractfactory.common.TreeNode;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.builder.AbstractConditionBuilder;
import net.abstractfactory.plum.view.web.component.builder.ConditionalComponentBuilderCollection;
import net.abstractfactory.plum.view.web.component.builder.WebViewBuilder;

import org.jsoup.nodes.Element;

public class WebDialogTitlePanel extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	public WebDialogTitlePanel(String id, Component component,
			Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), false);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		Element clearBr = findElementByClass("clear-br");
		clearBr.remove();
		
		htmlInnerElement.empty();

		htmlInnerElement.appendChild(clearBr);
	}

	@Override
	public void addChild(TreeNode node) {
		Element container = getHtmlInnerElementForNewChild();

		Element br = container.children().last();
		br.remove();

		super.addChild(node);

		container.appendChild(br);

	}

	@Override
	public String getComponentType() {

		return "dialogTitlePanel";
	}

	private static class ComponentBuilder extends AbstractConditionBuilder {
		@Override
		public Class getComponentClass() {
			return Panel.class;
		}
		@Override
		public boolean isMatch(Component component) {
			return checkClasses(component, Panel.class, Dialog.class)
					&& checkNames(component, Window.NAME_TITLE_PANEL);

		}

		@Override
		public WebComponent visit(WebViewBuilder builder, Component component) {
			return builder.commonVisitWithoutPreprocess(
					WebDialogTitlePanel.class, component);
		}

	}

	public static void registerBuilder(
			ConditionalComponentBuilderCollection collection) {

		collection.add(new ComponentBuilder());

		WebDialogTitleLabel.registerBuilder(collection);
		WebDialogCloseButton.registerBuilder(collection);

	}
}
