package net.abstractfactory.plum.view.web.component.container.window.dialog;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.builder.AbstractConditionBuilder;
import net.abstractfactory.plum.view.web.component.builder.ConditionalComponentBuilderCollection;
import net.abstractfactory.plum.view.web.component.builder.WebViewBuilder;

import org.jsoup.nodes.Element;

public class WebDialogTitleLabel extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	Element LabelElement;

	public WebDialogTitleLabel(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private Label getLabel() {
		return (Label) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		LabelElement = htmlInnerElement;

		LabelElement.text(getLabel().getText());

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "dialogTitleLabel";
	}

	private static class ComponentBuilder extends AbstractConditionBuilder {
		@Override
		public Class getComponentClass() {

			return Label.class;
		}

		@Override
		public boolean isMatch(Component component) {
			return checkClasses(component, Label.class, Panel.class, Dialog.class)
					&& component.getName().equals(Window.NAME_TITLE_LABEL);

		}

		@Override
		public WebComponent visit(WebViewBuilder builder, Component component) {
			return builder.commonVisitWithoutPreprocess(WebDialogTitleLabel.class, component);
		}

	}

	public static void registerBuilder(ConditionalComponentBuilderCollection collection) {

		collection.add(new ComponentBuilder());

	}
}
