package net.abstractfactory.plum.view.web.component.container.window.dialog;

import org.jsoup.nodes.Element;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.builder.AbstractConditionBuilder;
import net.abstractfactory.plum.view.web.component.builder.ConditionalComponentBuilderCollection;
import net.abstractfactory.plum.view.web.component.builder.WebViewBuilder;

public class WebDialogContentPanel extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	public WebDialogContentPanel(String id, Component component,
			Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "dialogContentPanel";
	}

	private static class ComponentBuilder extends AbstractConditionBuilder {
		@Override
		public Class getComponentClass() {
			 
			return Panel.class;
		}
		@Override
		public boolean isMatch(Component component) {
			return checkClasses(component, Panel.class, Dialog.class)
					&& checkNames(component, Window.NAME_CONTENT_PANEL);

		}

		@Override
		public WebComponent visit(WebViewBuilder builder, Component component) {
			return builder.commonVisitWithoutPreprocess(
					WebDialogContentPanel.class, component);
		}

	}

	public static void registerBuilder(
			ConditionalComponentBuilderCollection collection) {
		collection.add(new ComponentBuilder());
	}
}
